/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene86;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PointsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReadState;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ChecksumIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.BKDReader;

public class Lucene86PointsReader
extends PointsReader {
    final IndexInput indexIn;
    final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<Integer, PointValues> readers = new HashMap<Integer, PointValues>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene86PointsReader(SegmentReadState readState) throws IOException {
        this.readState = readState;
        String metaFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "kdm");
        String indexFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "kdi");
        String dataFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "kdd");
        boolean success = false;
        try {
            long dataLength;
            long indexLength;
            block15: {
                this.indexIn = EndiannessReverserUtil.openInput(readState.directory, indexFileName, readState.context);
                CodecUtil.checkIndexHeader(this.indexIn, "Lucene86PointsFormatIndex", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                this.dataIn = EndiannessReverserUtil.openInput(readState.directory, dataFileName, readState.context);
                CodecUtil.checkIndexHeader(this.dataIn, "Lucene86PointsFormatData", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                indexLength = -1L;
                dataLength = -1L;
                try (ChecksumIndexInput metaIn = EndiannessReverserUtil.openChecksumInput(readState.directory, metaFileName, readState.context);){
                    Throwable priorE = null;
                    try {
                        int fieldNumber;
                        CodecUtil.checkIndexHeader(metaIn, "Lucene86PointsFormatMeta", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                        while ((fieldNumber = metaIn.readInt()) != -1) {
                            if (fieldNumber < 0) {
                                throw new CorruptIndexException("Illegal field number: " + fieldNumber, metaIn);
                            }
                            BKDReader reader = new BKDReader(metaIn, this.indexIn, this.dataIn);
                            this.readers.put(fieldNumber, reader);
                        }
                        indexLength = metaIn.readLong();
                        dataLength = metaIn.readLong();
                    }
                    catch (Throwable t) {
                        try {
                            priorE = t;
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter(metaIn, priorE);
                        }
                    }
                    CodecUtil.checkFooter(metaIn, priorE);
                }
            }
            CodecUtil.retrieveChecksum(this.indexIn, indexLength);
            CodecUtil.retrieveChecksum(this.dataIn, dataLength);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public PointValues getValues(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return this.readers.get(fieldInfo.number);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexIn);
        CodecUtil.checksumEntireFile(this.dataIn);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.indexIn, this.dataIn);
        this.readers.clear();
    }
}

