/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnVectorsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocIDMerger;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergeState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Sorter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorEncoding;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;

public abstract class KnnVectorsWriter
implements Accountable,
Closeable {
    protected KnnVectorsWriter() {
    }

    public abstract KnnFieldVectorsWriter<?> addField(FieldInfo var1) throws IOException;

    public abstract void flush(int var1, Sorter.DocMap var2) throws IOException;

    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        switch (fieldInfo.getVectorEncoding()) {
            case BYTE: {
                KnnFieldVectorsWriter<?> byteWriter = this.addField(fieldInfo);
                ByteVectorValues mergedBytes = MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState);
                int doc = mergedBytes.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    byteWriter.addValue(doc, mergedBytes.vectorValue());
                    doc = mergedBytes.nextDoc();
                }
                break;
            }
            case FLOAT32: {
                KnnFieldVectorsWriter<?> floatWriter = this.addField(fieldInfo);
                FloatVectorValues mergedFloats = MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
                int doc = mergedFloats.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    floatWriter.addValue(doc, mergedFloats.vectorValue());
                    doc = mergedFloats.nextDoc();
                }
                break;
            }
        }
    }

    public abstract void finish() throws IOException;

    public final void merge(MergeState mergeState) throws IOException {
        for (int i = 0; i < mergeState.fieldInfos.length; ++i) {
            KnnVectorsReader reader = mergeState.knnVectorsReaders[i];
            assert (reader != null || !mergeState.fieldInfos[i].hasVectorValues());
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (!fieldInfo.hasVectorValues()) continue;
            if (mergeState.infoStream.isEnabled("VV")) {
                mergeState.infoStream.message("VV", "merging " + mergeState.segmentInfo);
            }
            this.mergeOneField(fieldInfo, mergeState);
            if (!mergeState.infoStream.isEnabled("VV")) continue;
            mergeState.infoStream.message("VV", "merge done " + mergeState.segmentInfo);
        }
        this.finish();
    }

    protected static final class MergedVectorValues {
        private MergedVectorValues() {
        }

        public static FloatVectorValues mergeFloatVectorValues(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            assert (fieldInfo != null && fieldInfo.hasVectorValues());
            if (fieldInfo.getVectorEncoding() != VectorEncoding.FLOAT32) {
                throw new UnsupportedOperationException("Cannot merge vectors encoded as [" + fieldInfo.getVectorEncoding() + "] as FLOAT32");
            }
            ArrayList<VectorValuesSub> subs = new ArrayList<VectorValuesSub>();
            for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
                FloatVectorValues values;
                KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
                if (knnVectorsReader == null || (values = knnVectorsReader.getFloatVectorValues(fieldInfo.name)) == null) continue;
                subs.add(new VectorValuesSub(mergeState.docMaps[i], values));
            }
            return new MergedFloat32VectorValues(subs, mergeState);
        }

        public static ByteVectorValues mergeByteVectorValues(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            assert (fieldInfo != null && fieldInfo.hasVectorValues());
            if (fieldInfo.getVectorEncoding() != VectorEncoding.BYTE) {
                throw new UnsupportedOperationException("Cannot merge vectors encoded as [" + fieldInfo.getVectorEncoding() + "] as BYTE");
            }
            ArrayList<ByteVectorValuesSub> subs = new ArrayList<ByteVectorValuesSub>();
            for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
                ByteVectorValues values;
                KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
                if (knnVectorsReader == null || (values = knnVectorsReader.getByteVectorValues(fieldInfo.name)) == null) continue;
                subs.add(new ByteVectorValuesSub(mergeState.docMaps[i], values));
            }
            return new MergedByteVectorValues(subs, mergeState);
        }

        static class MergedByteVectorValues
        extends ByteVectorValues {
            private final List<ByteVectorValuesSub> subs;
            private final DocIDMerger<ByteVectorValuesSub> docIdMerger;
            private final int size;
            private int docId;
            ByteVectorValuesSub current;

            private MergedByteVectorValues(List<ByteVectorValuesSub> subs, MergeState mergeState) throws IOException {
                this.subs = subs;
                this.docIdMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                int totalSize = 0;
                for (ByteVectorValuesSub sub : subs) {
                    totalSize += sub.values.size();
                }
                this.size = totalSize;
                this.docId = -1;
            }

            @Override
            public byte[] vectorValue() throws IOException {
                return this.current.values.vectorValue();
            }

            @Override
            public int docID() {
                return this.docId;
            }

            @Override
            public int nextDoc() throws IOException {
                this.current = this.docIdMerger.next();
                this.docId = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docId;
            }

            @Override
            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public int dimension() {
                return this.subs.get((int)0).values.dimension();
            }
        }

        static class MergedFloat32VectorValues
        extends FloatVectorValues {
            private final List<VectorValuesSub> subs;
            private final DocIDMerger<VectorValuesSub> docIdMerger;
            private final int size;
            private int docId;
            VectorValuesSub current;

            private MergedFloat32VectorValues(List<VectorValuesSub> subs, MergeState mergeState) throws IOException {
                this.subs = subs;
                this.docIdMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                int totalSize = 0;
                for (VectorValuesSub sub : subs) {
                    totalSize += sub.values.size();
                }
                this.size = totalSize;
                this.docId = -1;
            }

            @Override
            public int docID() {
                return this.docId;
            }

            @Override
            public int nextDoc() throws IOException {
                this.current = this.docIdMerger.next();
                this.docId = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docId;
            }

            @Override
            public float[] vectorValue() throws IOException {
                return this.current.values.vectorValue();
            }

            @Override
            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public int dimension() {
                return this.subs.get((int)0).values.dimension();
            }
        }
    }

    private static class ByteVectorValuesSub
    extends DocIDMerger.Sub {
        final ByteVectorValues values;

        ByteVectorValuesSub(MergeState.DocMap docMap, ByteVectorValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    private static class VectorValuesSub
    extends DocIDMerger.Sub {
        final FloatVectorValues values;

        VectorValuesSub(MergeState.DocMap docMap, FloatVectorValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }
}

