/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;

class ParallelPostingsArray {
    static final int BYTES_PER_POSTING = 12;
    final int size;
    final int[] textStarts;
    final int[] addressOffset;
    final int[] byteStarts;

    ParallelPostingsArray(int size) {
        this.size = size;
        this.textStarts = new int[size];
        this.addressOffset = new int[size];
        this.byteStarts = new int[size];
    }

    int bytesPerPosting() {
        return 12;
    }

    ParallelPostingsArray newInstance(int size) {
        return new ParallelPostingsArray(size);
    }

    final ParallelPostingsArray grow() {
        int newSize = ArrayUtil.oversize(this.size + 1, this.bytesPerPosting());
        ParallelPostingsArray newArray = this.newInstance(newSize);
        this.copyTo(newArray, this.size);
        return newArray;
    }

    void copyTo(ParallelPostingsArray toArray, int numToCopy) {
        System.arraycopy(this.textStarts, 0, toArray.textStarts, 0, numToCopy);
        System.arraycopy(this.addressOffset, 0, toArray.addressOffset, 0, numToCopy);
        System.arraycopy(this.byteStarts, 0, toArray.byteStarts, 0, numToCopy);
    }
}

