/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import java.io.IOException;
import java.util.regex.Pattern;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.Intervals;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.IntervalsSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class AnalyzedText
extends IntervalFunction {
    private final String term;

    public AnalyzedText(String term) {
        this.term = term;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        int gaps = 0;
        boolean ordered = true;
        try {
            return Intervals.analyzedText(this.term, analyzer, field, gaps, ordered);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        if (AnalyzedText.requiresQuotes(this.term)) {
            return "\"" + this.term + "\"";
        }
        return this.term;
    }

    static boolean requiresQuotes(String term) {
        return Pattern.compile("[\\s]").matcher(term).find();
    }
}

