/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ByteVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Fields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafMetaData;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StoredFieldVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.StoredFields;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermVectors;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Terms;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorEncoding;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Version;

public class TermVectorLeafReader
extends LeafReader {
    private final Fields fields;
    private final FieldInfos fieldInfos;

    public TermVectorLeafReader(final String field, final Terms terms) {
        this.fields = new Fields(){

            @Override
            public Iterator<String> iterator() {
                return Collections.singletonList(field).iterator();
            }

            @Override
            public Terms terms(String fld) throws IOException {
                if (!field.equals(fld)) {
                    return null;
                }
                return terms;
            }

            @Override
            public int size() {
                return 1;
            }
        };
        IndexOptions indexOptions = !terms.hasFreqs() ? IndexOptions.DOCS : (!terms.hasPositions() ? IndexOptions.DOCS_AND_FREQS : (!terms.hasOffsets() ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS));
        FieldInfo fieldInfo = new FieldInfo(field, 0, true, true, terms.hasPayloads(), indexOptions, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false);
        this.fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public Terms terms(String field) throws IOException {
        return this.fields.terms(field);
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return null;
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return null;
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return null;
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return null;
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return null;
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        return null;
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public Bits getLiveDocs() {
        return null;
    }

    @Override
    public PointValues getPointValues(String fieldName) {
        return null;
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String fieldName) {
        return null;
    }

    @Override
    public ByteVectorValues getByteVectorValues(String fieldName) {
        return null;
    }

    @Override
    public TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) {
        return null;
    }

    @Override
    public TopDocs searchNearestVectors(String field, byte[] target, int k, Bits acceptDocs, int visitedLimit) {
        return null;
    }

    @Override
    public void checkIntegrity() throws IOException {
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        if (docID != 0) {
            return null;
        }
        return this.fields;
    }

    @Override
    public TermVectors termVectors() throws IOException {
        return new TermVectors(){

            @Override
            public Fields get(int docID) {
                if (docID != 0) {
                    return null;
                }
                return TermVectorLeafReader.this.fields;
            }
        };
    }

    @Override
    public int numDocs() {
        return 1;
    }

    @Override
    public int maxDoc() {
        return 1;
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
    }

    @Override
    public StoredFields storedFields() throws IOException {
        return new StoredFields(){

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            }
        };
    }

    @Override
    public LeafMetaData getMetaData() {
        return new LeafMetaData(Version.LATEST.major, null, null);
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }
}

