/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

import org.graylog.shaded.opensearch2.org.apache.lucene.util.VectorUtilProvider;

public final class VectorUtil {
    private static final VectorUtilProvider PROVIDER = VectorUtilProvider.lookup(false);

    private VectorUtil() {
    }

    public static float dotProduct(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = PROVIDER.dotProduct(a, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static float cosine(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = PROVIDER.cosine(a, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static float cosine(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return PROVIDER.cosine(a, b);
    }

    public static float squareDistance(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = PROVIDER.squareDistance(a, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static int squareDistance(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return PROVIDER.squareDistance(a, b);
    }

    public static float[] l2normalize(float[] v) {
        VectorUtil.l2normalize(v, true);
        return v;
    }

    public static float[] l2normalize(float[] v, boolean throwOnZero) {
        double squareSum = 0.0;
        int dim = v.length;
        for (float x : v) {
            squareSum += (double)(x * x);
        }
        if (squareSum == 0.0) {
            if (throwOnZero) {
                throw new IllegalArgumentException("Cannot normalize a zero-length vector");
            }
            return v;
        }
        double length = Math.sqrt(squareSum);
        int i = 0;
        while (i < dim) {
            int n = i++;
            v[n] = (float)((double)v[n] / length);
        }
        return v;
    }

    public static void add(float[] u, float[] v) {
        for (int i = 0; i < u.length; ++i) {
            int n = i;
            u[n] = u[n] + v[i];
        }
    }

    public static int dotProduct(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return PROVIDER.dotProduct(a, b);
    }

    public static float dotProductScore(byte[] a, byte[] b) {
        float denom = a.length * 32768;
        return 0.5f + (float)VectorUtil.dotProduct(a, b) / denom;
    }

    public static float[] checkFinite(float[] v) {
        for (int i = 0; i < v.length; ++i) {
            if (Float.isFinite(v[i])) continue;
            throw new IllegalArgumentException("non-finite value at vector[" + i + "]=" + v[i]);
        }
        return v;
    }
}

