/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.allocation.ClusterAllocationExplainRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.allocation.ClusterAllocationExplainResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.allocation.ClusterAllocationExplanation;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterInfoService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocationService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.ShardAllocationDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotsInfoService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportClusterAllocationExplainAction
extends TransportClusterManagerNodeAction<ClusterAllocationExplainRequest, ClusterAllocationExplainResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterAllocationExplainAction.class);
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final AllocationDeciders allocationDeciders;
    private final ShardsAllocator shardAllocator;
    private final AllocationService allocationService;

    @Inject
    public TransportClusterAllocationExplainAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AllocationDeciders allocationDeciders, ShardsAllocator shardAllocator, AllocationService allocationService) {
        super("cluster:monitor/allocation/explain", transportService, clusterService, threadPool, actionFilters, ClusterAllocationExplainRequest::new, indexNameExpressionResolver);
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
        this.allocationDeciders = allocationDeciders;
        this.shardAllocator = shardAllocator;
        this.allocationService = allocationService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected ClusterAllocationExplainResponse read(StreamInput in) throws IOException {
        return new ClusterAllocationExplainResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterAllocationExplainRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void clusterManagerOperation(ClusterAllocationExplainRequest request, ClusterState state, ActionListener<ClusterAllocationExplainResponse> listener) {
        RoutingNodes routingNodes = state.getRoutingNodes();
        ClusterInfo clusterInfo = this.clusterInfoService.getClusterInfo();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, state, clusterInfo, this.snapshotsInfoService.snapshotShardSizes(), System.nanoTime());
        ShardRouting shardRouting = TransportClusterAllocationExplainAction.findShardToExplain(request, allocation);
        logger.debug("explaining the allocation for [{}], found shard [{}]", (Object)request, (Object)shardRouting);
        ClusterAllocationExplanation cae = TransportClusterAllocationExplainAction.explainShard(shardRouting, allocation, request.includeDiskInfo() ? clusterInfo : null, request.includeYesDecisions(), this.allocationService);
        listener.onResponse(new ClusterAllocationExplainResponse(cae));
    }

    public static ClusterAllocationExplanation explainShard(ShardRouting shardRouting, RoutingAllocation allocation, ClusterInfo clusterInfo, boolean includeYesDecisions, AllocationService allocationService) {
        allocation.setDebugMode(includeYesDecisions ? RoutingAllocation.DebugMode.ON : RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        ShardAllocationDecision shardDecision = shardRouting.initializing() || shardRouting.relocating() ? ShardAllocationDecision.NOT_TAKEN : allocationService.explainShardAllocation(shardRouting, allocation);
        return new ClusterAllocationExplanation(shardRouting, shardRouting.currentNodeId() != null ? allocation.nodes().get(shardRouting.currentNodeId()) : null, shardRouting.relocatingNodeId() != null ? allocation.nodes().get(shardRouting.relocatingNodeId()) : null, clusterInfo, shardDecision);
    }

    public static ShardRouting findShardToExplain(ClusterAllocationExplainRequest request, RoutingAllocation allocation) {
        ShardRouting foundShard = null;
        if (request.useAnyUnassignedShard()) {
            RoutingNodes.UnassignedShards.UnassignedIterator ui = allocation.routingNodes().unassigned().iterator();
            if (ui.hasNext()) {
                foundShard = ui.next();
            }
            if (foundShard == null) {
                throw new IllegalArgumentException("unable to find any unassigned shards to explain [" + request + "]");
            }
        } else {
            String index = request.getIndex();
            int shard = request.getShard();
            if (request.isPrimary().booleanValue()) {
                DiscoveryNode primaryNode;
                foundShard = allocation.routingTable().shardRoutingTable(index, shard).primaryShard();
                if (request.getCurrentNode() != null && !(primaryNode = allocation.nodes().resolveNode(request.getCurrentNode())).getId().equals(foundShard.currentNodeId())) {
                    throw new IllegalArgumentException("unable to find primary shard assigned to node [" + request.getCurrentNode() + "]");
                }
            } else {
                List<ShardRouting> replicaShardRoutings = allocation.routingTable().shardRoutingTable(index, shard).replicaShards();
                if (request.getCurrentNode() != null) {
                    DiscoveryNode replicaNode = allocation.nodes().resolveNode(request.getCurrentNode());
                    for (ShardRouting replica : replicaShardRoutings) {
                        if (!replicaNode.getId().equals(replica.currentNodeId())) continue;
                        foundShard = replica;
                        break;
                    }
                    if (foundShard == null) {
                        throw new IllegalArgumentException("unable to find a replica shard assigned to node [" + request.getCurrentNode() + "]");
                    }
                } else if (replicaShardRoutings.size() > 0) {
                    foundShard = replicaShardRoutings.get(0);
                    for (ShardRouting replica : replicaShardRoutings) {
                        if (replica.unassigned()) {
                            foundShard = replica;
                            break;
                        }
                        if (!replica.started() || !foundShard.initializing() && !foundShard.relocating()) continue;
                        foundShard = replica;
                    }
                }
            }
        }
        if (foundShard == null) {
            throw new IllegalArgumentException("unable to find any shards to explain [" + request + "] in the routing table");
        }
        return foundShard;
    }
}

