/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.configuration;

import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.configuration.TransportAddVotingConfigExclusionsAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;

public class VotingConfigExclusionsHelper {
    public static ClusterState addExclusionAndGetState(ClusterState currentState, Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions, int finalMaxVotingConfigExclusions) {
        CoordinationMetadata.Builder builder = CoordinationMetadata.builder(currentState.coordinationMetadata());
        resolvedExclusions.forEach(builder::addVotingConfigExclusion);
        Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(builder.build()).build();
        ClusterState newState = ClusterState.builder(currentState).metadata(newMetadata).build();
        assert (newState.getVotingConfigExclusions().size() <= finalMaxVotingConfigExclusions);
        return newState;
    }

    public static Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusionsAndCheckMaximum(AddVotingConfigExclusionsRequest request, ClusterState state, int maxVotingConfigExclusions) {
        return request.resolveVotingConfigExclusionsAndCheckMaximum(state, maxVotingConfigExclusions, TransportAddVotingConfigExclusionsAction.MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.getKey());
    }

    public static ClusterState clearExclusionsAndGetState(ClusterState currentState) {
        CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).clearVotingConfigExclusions().build();
        Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(newCoordinationMetadata).build();
        return ClusterState.builder(currentState).metadata(newMetadata).build();
    }
}

