/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.remotestore.restore;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.remotestore.restore.RestoreRemoteStoreRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.remotestore.restore.RestoreRemoteStoreResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.RestoreService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public final class TransportRestoreRemoteStoreAction
extends TransportClusterManagerNodeAction<RestoreRemoteStoreRequest, RestoreRemoteStoreResponse> {
    private final RestoreService restoreService;

    @Inject
    public TransportRestoreRemoteStoreAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RestoreService restoreService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/remotestore/restore", transportService, clusterService, threadPool, actionFilters, RestoreRemoteStoreRequest::new, indexNameExpressionResolver);
        this.restoreService = restoreService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected RestoreRemoteStoreResponse read(StreamInput in) throws IOException {
        return new RestoreRemoteStoreResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(RestoreRemoteStoreRequest request, ClusterState state) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (blockException != null) {
            return blockException;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected void clusterManagerOperation(RestoreRemoteStoreRequest request, ClusterState state, ActionListener<RestoreRemoteStoreResponse> listener) {
        this.restoreService.restoreFromRemoteStore(request, ActionListener.delegateFailure(listener, (delegatedListener, restoreCompletionResponse) -> {
            if (restoreCompletionResponse.getRestoreInfo() == null && request.waitForCompletion()) {
                RestoreClusterStateListener.createAndRegisterListener(this.clusterService, restoreCompletionResponse, delegatedListener, RestoreRemoteStoreResponse::new);
            } else {
                delegatedListener.onResponse(new RestoreRemoteStoreResponse(restoreCompletionResponse.getRestoreInfo()));
            }
        }));
    }
}

