/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.SettingsUpdater;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.AckedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocationService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportClusterUpdateSettingsAction
extends TransportClusterManagerNodeAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterUpdateSettingsAction.class);
    private final AllocationService allocationService;
    private final ClusterSettings clusterSettings;
    private final ClusterManagerTaskThrottler.ThrottlingKey clusterUpdateSettingTaskKey;

    @Inject
    public TransportClusterUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterSettings clusterSettings) {
        super("cluster:admin/settings/update", false, transportService, clusterService, threadPool, actionFilters, ClusterUpdateSettingsRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        this.clusterSettings = clusterSettings;
        this.clusterUpdateSettingTaskKey = clusterService.registerClusterManagerTask("cluster-update-settings", true);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterUpdateSettingsRequest request, ClusterState state) {
        if (request.transientSettings().size() + request.persistentSettings().size() == 1 && (Metadata.SETTING_READ_ONLY_SETTING.exists(request.persistentSettings()) || Metadata.SETTING_READ_ONLY_SETTING.exists(request.transientSettings()) || Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.transientSettings()) || Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.persistentSettings()))) {
            return null;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterUpdateSettingsResponse read(StreamInput in) throws IOException {
        return new ClusterUpdateSettingsResponse(in);
    }

    @Override
    protected void clusterManagerOperation(final ClusterUpdateSettingsRequest request, ClusterState state, final ActionListener<ClusterUpdateSettingsResponse> listener) {
        final SettingsUpdater updater = new SettingsUpdater(this.clusterSettings);
        this.clusterService.submitStateUpdateTask("cluster_update_settings", new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.IMMEDIATE, (AckedRequest)request, listener){
            private volatile boolean changed;
            {
                super(priority, request2, listener2);
                this.changed = false;
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return TransportClusterUpdateSettingsAction.this.clusterUpdateSettingTaskKey;
            }

            @Override
            protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                return new ClusterUpdateSettingsResponse(acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    super.onAllNodesAcked(e);
                }
            }

            @Override
            public void onAckTimeout() {
                if (this.changed) {
                    this.reroute(false);
                } else {
                    super.onAckTimeout();
                }
            }

            private void reroute(final boolean updateSettingsAcked) {
                if (!TransportClusterUpdateSettingsAction.this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
                    logger.debug("Skipping reroute after cluster update settings, because node is no longer cluster-manager");
                    listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    return;
                }
                TransportClusterUpdateSettingsAction.this.clusterService.submitStateUpdateTask("reroute_after_cluster_update_settings", new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.URGENT, (AckedRequest)request, listener){

                    @Override
                    public boolean mustAck(DiscoveryNode discoveryNode) {
                        return updateSettingsAcked;
                    }

                    @Override
                    protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                        return new ClusterUpdateSettingsResponse(updateSettingsAcked && acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
                    }

                    @Override
                    public void onNoLongerClusterManager(String source) {
                        logger.debug("failed to preform reroute after cluster settings were updated - current node is no longer a cluster-manager");
                        listener.onResponse(new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                        listener.onFailure(new OpenSearchException("reroute after update settings failed", (Throwable)e, new Object[0]));
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return TransportClusterUpdateSettingsAction.this.allocationService.reroute(currentState, "reroute after cluster update settings");
                    }
                });
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                super.onFailure(source, e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ClusterState clusterState = updater.updateSettings(currentState, TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.transientSettings()), TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.persistentSettings()), logger);
                this.changed = clusterState != currentState;
                return clusterState;
            }
        });
    }
}

