/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;

public class ClusterSearchShardsGroup
implements Writeable,
ToXContentObject {
    private final ShardId shardId;
    private final ShardRouting[] shards;

    public ClusterSearchShardsGroup(ShardId shardId, ShardRouting[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    ClusterSearchShardsGroup(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.shards = in.readArray(i -> new ShardRouting(this.shardId, i), ShardRouting[]::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeArray((o, s) -> s.writeToThin(o), this.shards);
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardRouting[] getShards() {
        return this.shards;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (ShardRouting shard : this.getShards()) {
            shard.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

