/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.clone;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class CloneSnapshotRequest
extends ClusterManagerNodeRequest<CloneSnapshotRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    private final String repository;
    private final String source;
    private final String target;
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandHidden();

    public CloneSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.source = in.readString();
        this.target = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    public CloneSnapshotRequest(String repository, String source, String target, String[] indices) {
        this.repository = repository;
        this.source = source;
        this.target = target;
        this.indices = indices;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeString(this.source);
        out.writeString(this.target);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source snapshot name is missing", null);
        }
        if (this.target == null) {
            validationException = ValidateActions.addValidationError("target snapshot name is missing", null);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices is null", validationException);
        } else if (this.indices.length == 0) {
            validationException = ValidateActions.addValidationError("indices patterns are empty", validationException);
        } else {
            for (String index : this.indices) {
                if (index != null) continue;
                validationException = ValidateActions.addValidationError("index is null", validationException);
                break;
            }
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public CloneSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public CloneSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String target() {
        return this.target;
    }

    public String source() {
        return this.source;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("repository", this.repository);
        builder.field("source", this.source);
        builder.field("target", this.target);
        if (this.indices != null) {
            builder.startArray("indices");
            for (String index : this.indices) {
                builder.value(index);
            }
            builder.endArray();
        }
        if (this.indicesOptions != null) {
            this.indicesOptions.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(XContentType.JSON, this);
    }
}

