/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.AnalysisStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.ClusterStatsIndices;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.ClusterStatsNodes;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.MappingStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.health.ClusterHealthStatus;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class ClusterStatsResponse
extends BaseNodesResponse<ClusterStatsNodeResponse>
implements ToXContentFragment {
    final ClusterStatsNodes nodesStats;
    final ClusterStatsIndices indicesStats;
    final ClusterHealthStatus status;
    final long timestamp;
    final String clusterUUID;

    public ClusterStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readVLong();
        this.status = in.readOptionalWriteable(ClusterHealthStatus::readFrom);
        String clusterUUID = null;
        MappingStats mappingStats = null;
        AnalysisStats analysisStats = null;
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_7_0)) {
            clusterUUID = in.readOptionalString();
            mappingStats = in.readOptionalWriteable(MappingStats::new);
            analysisStats = in.readOptionalWriteable(AnalysisStats::new);
        }
        this.clusterUUID = clusterUUID;
        this.nodesStats = new ClusterStatsNodes(this.getNodes());
        this.indicesStats = new ClusterStatsIndices(this.getNodes(), mappingStats, analysisStats);
    }

    public ClusterStatsResponse(long timestamp, String clusterUUID, ClusterName clusterName, List<ClusterStatsNodeResponse> nodes, List<FailedNodeException> failures, ClusterState state) {
        super(clusterName, nodes, failures);
        this.clusterUUID = clusterUUID;
        this.timestamp = timestamp;
        this.nodesStats = new ClusterStatsNodes(nodes);
        this.indicesStats = new ClusterStatsIndices(nodes, MappingStats.of(state), AnalysisStats.of(state));
        ClusterHealthStatus status = null;
        for (ClusterStatsNodeResponse response : nodes) {
            if (response.clusterStatus() == null) continue;
            status = response.clusterStatus();
            break;
        }
        this.status = status;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public ClusterStatsNodes getNodesStats() {
        return this.nodesStats;
    }

    public ClusterStatsIndices getIndicesStats() {
        return this.indicesStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        out.writeOptionalWriteable(this.status);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_7_0)) {
            out.writeOptionalString(this.clusterUUID);
            out.writeOptionalWriteable(this.indicesStats.getMappings());
            out.writeOptionalWriteable(this.indicesStats.getAnalysis());
        }
    }

    @Override
    protected List<ClusterStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(ClusterStatsNodeResponse::readNodeResponse);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<ClusterStatsNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_uuid", this.getClusterUUID());
        builder.field("timestamp", this.getTimestamp());
        if (this.status != null) {
            builder.field("status", this.status.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("indices");
        this.indicesStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("nodes");
        this.nodesStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

