/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.StatusToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptContextInfo;

public class GetScriptContextResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
    final Map<String, ScriptContextInfo> contexts;
    public static final ConstructingObjectParser<GetScriptContextResponse, Void> PARSER = new ConstructingObjectParser("get_script_context", true, a -> {
        Map<String, ScriptContextInfo> contexts = ((List)a[0]).stream().collect(Collectors.toMap(ScriptContextInfo::getName, c -> c));
        return new GetScriptContextResponse(contexts);
    });

    GetScriptContextResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readInt();
        HashMap<String, ScriptContextInfo> contexts = new HashMap<String, ScriptContextInfo>(size);
        for (int i = 0; i < size; ++i) {
            ScriptContextInfo info = new ScriptContextInfo(in);
            contexts.put(info.name, info);
        }
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    GetScriptContextResponse(Set<ScriptContextInfo> contexts) {
        this.contexts = Collections.unmodifiableMap(contexts.stream().collect(Collectors.toMap(ScriptContextInfo::getName, Function.identity())));
    }

    private GetScriptContextResponse(Map<String, ScriptContextInfo> contexts) {
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    private List<ScriptContextInfo> byName() {
        return this.contexts.values().stream().sorted(Comparator.comparing(ScriptContextInfo::getName)).collect(Collectors.toList());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.contexts.size());
        for (ScriptContextInfo context : this.contexts.values()) {
            context.writeTo(out);
        }
    }

    @Override
    public RestStatus status() {
        return RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startArray(CONTEXTS.getPreferredName());
        for (ScriptContextInfo context : this.byName()) {
            context.toXContent(builder, params);
        }
        builder.endArray().endObject();
        return builder;
    }

    public static GetScriptContextResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetScriptContextResponse that = (GetScriptContextResponse)o;
        return this.contexts.equals(that.contexts);
    }

    public int hashCode() {
        return Objects.hash(this.contexts);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ctx) -> ScriptContextInfo.PARSER.apply(parser, (Void)ctx), CONTEXTS);
    }
}

