/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.tasks;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.PendingClusterTask;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class PendingClusterTasksResponse
extends ActionResponse
implements Iterable<PendingClusterTask>,
ToXContentObject {
    private final List<PendingClusterTask> pendingTasks;

    public PendingClusterTasksResponse(StreamInput in) throws IOException {
        super(in);
        this.pendingTasks = in.readList(PendingClusterTask::new);
    }

    PendingClusterTasksResponse(List<PendingClusterTask> pendingTasks) {
        this.pendingTasks = pendingTasks;
    }

    public List<PendingClusterTask> pendingTasks() {
        return this.pendingTasks;
    }

    public List<PendingClusterTask> getPendingTasks() {
        return this.pendingTasks();
    }

    @Override
    public Iterator<PendingClusterTask> iterator() {
        return this.pendingTasks.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tasks: (").append(this.pendingTasks.size()).append("):\n");
        for (PendingClusterTask pendingClusterTask : this) {
            sb.append(pendingClusterTask.getInsertOrder()).append("/").append((Object)pendingClusterTask.getPriority()).append("/").append(pendingClusterTask.getSource()).append("/").append(pendingClusterTask.getTimeInQueue()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("tasks");
        for (PendingClusterTask pendingClusterTask : this) {
            builder.startObject();
            builder.field("insert_order", pendingClusterTask.getInsertOrder());
            builder.field("priority", (Object)pendingClusterTask.getPriority());
            builder.field("source", pendingClusterTask.getSource());
            builder.field("executing", pendingClusterTask.isExecuting());
            builder.field("time_in_queue_millis", pendingClusterTask.getTimeInQueueInMillis());
            builder.field("time_in_queue", pendingClusterTask.getTimeInQueue());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.pendingTasks);
    }

    static final class Fields {
        static final String TASKS = "tasks";
        static final String EXECUTING = "executing";
        static final String INSERT_ORDER = "insert_order";
        static final String PRIORITY = "priority";
        static final String SOURCE = "source";
        static final String TIME_IN_QUEUE_MILLIS = "time_in_queue_millis";
        static final String TIME_IN_QUEUE = "time_in_queue";

        Fields() {
        }
    }
}

