/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.get;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.OriginalIndices;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.single.shard.SingleShardRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;

public class GetFieldMappingsIndexRequest
extends SingleShardRequest<GetFieldMappingsIndexRequest> {
    private final boolean includeDefaults;
    private final String[] fields;
    private final OriginalIndices originalIndices;

    GetFieldMappingsIndexRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readStringArray();
        }
        this.fields = in.readStringArray();
        this.includeDefaults = in.readBoolean();
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readBoolean();
        }
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    GetFieldMappingsIndexRequest(GetFieldMappingsRequest other, String index) {
        this.includeDefaults = other.includeDefaults();
        this.fields = other.fields();
        assert (index != null);
        this.index(index);
        this.originalIndices = new OriginalIndices(other);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String[] fields() {
        return this.fields;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        out.writeStringArray(this.fields);
        out.writeBoolean(this.includeDefaults);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeBoolean(false);
        }
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }
}

