/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.replication;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.DefaultShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.BroadcastResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.SegmentReplicationPerGroupStats;

public class SegmentReplicationStatsResponse
extends BroadcastResponse {
    private final Map<String, List<SegmentReplicationPerGroupStats>> replicationStats;

    public SegmentReplicationStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.replicationStats = in.readMapOfLists(StreamInput::readString, SegmentReplicationPerGroupStats::new);
    }

    public SegmentReplicationStatsResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<SegmentReplicationPerGroupStats>> replicationStats, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.replicationStats = replicationStats;
    }

    public Map<String, List<SegmentReplicationPerGroupStats>> getReplicationStats() {
        return this.replicationStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.replicationStats.size() > 0) {
            for (String index : this.replicationStats.keySet()) {
                List<SegmentReplicationPerGroupStats> segmentReplicationStates = this.replicationStats.get(index);
                if (segmentReplicationStates == null || segmentReplicationStates.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("primary_stats");
                for (SegmentReplicationPerGroupStats segmentReplicationState : segmentReplicationStates) {
                    builder.startObject();
                    segmentReplicationState.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMapOfLists(this.replicationStats, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    public String toString() {
        return Strings.toString(XContentType.JSON, this, true, true);
    }
}

