/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.replication.SegmentReplicationShardStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.replication.SegmentReplicationStatsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.replication.SegmentReplicationStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.DefaultShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.SegmentReplicationPerGroupStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.SegmentReplicationPressureService;
import org.graylog.shaded.opensearch2.org.opensearch.index.SegmentReplicationShardStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationState;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportSegmentReplicationStatsAction
extends TransportBroadcastByNodeAction<SegmentReplicationStatsRequest, SegmentReplicationStatsResponse, SegmentReplicationShardStatsResponse> {
    private final SegmentReplicationTargetService targetService;
    private final IndicesService indicesService;
    private final SegmentReplicationPressureService pressureService;

    @Inject
    public TransportSegmentReplicationStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, SegmentReplicationTargetService targetService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SegmentReplicationPressureService pressureService) {
        super("indices:monitor/segment_replication", clusterService, transportService, actionFilters, indexNameExpressionResolver, SegmentReplicationStatsRequest::new, "management");
        this.indicesService = indicesService;
        this.targetService = targetService;
        this.pressureService = pressureService;
    }

    @Override
    protected SegmentReplicationShardStatsResponse readShardResult(StreamInput in) throws IOException {
        return new SegmentReplicationShardStatsResponse(in);
    }

    @Override
    protected SegmentReplicationStatsResponse newResponse(SegmentReplicationStatsRequest request, int totalShards, int successfulShards, int failedShards, List<SegmentReplicationShardStatsResponse> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        String[] shards = request.shards();
        List shardsToFetch = Arrays.stream(shards).map(Integer::valueOf).collect(Collectors.toList());
        HashMap<String, SegmentReplicationState> replicaStats = new HashMap<String, SegmentReplicationState>();
        HashMap<String, List<SegmentReplicationPerGroupStats>> primaryStats = new HashMap<String, List<SegmentReplicationPerGroupStats>>();
        for (SegmentReplicationShardStatsResponse segmentReplicationShardStatsResponse : responses) {
            if (segmentReplicationShardStatsResponse == null) continue;
            if (segmentReplicationShardStatsResponse.getReplicaStats() != null) {
                ShardRouting shardRouting = segmentReplicationShardStatsResponse.getReplicaStats().getShardRouting();
                if (shardsToFetch.isEmpty() || shardsToFetch.contains(shardRouting.shardId().getId())) {
                    replicaStats.putIfAbsent(shardRouting.allocationId().getId(), segmentReplicationShardStatsResponse.getReplicaStats());
                }
            }
            if (segmentReplicationShardStatsResponse.getPrimaryStats() == null) continue;
            ShardId shardId = segmentReplicationShardStatsResponse.getPrimaryStats().getShardId();
            if (!shardsToFetch.isEmpty() && !shardsToFetch.contains(shardId.getId())) continue;
            primaryStats.compute(shardId.getIndexName(), (k, v) -> {
                if (v == null) {
                    ArrayList<SegmentReplicationPerGroupStats> list = new ArrayList<SegmentReplicationPerGroupStats>();
                    list.add(response.getPrimaryStats());
                    return list;
                }
                v.add(response.getPrimaryStats());
                return v;
            });
        }
        for (Map.Entry entry : primaryStats.entrySet()) {
            for (SegmentReplicationPerGroupStats group : (List)entry.getValue()) {
                for (SegmentReplicationShardStats replicaStat : group.getReplicaStats()) {
                    replicaStat.setCurrentReplicationState(replicaStats.getOrDefault(replicaStat.getAllocationId(), null));
                }
            }
        }
        return new SegmentReplicationStatsResponse(totalShards, successfulShards, failedShards, primaryStats, shardFailures);
    }

    @Override
    protected SegmentReplicationStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new SegmentReplicationStatsRequest(in);
    }

    @Override
    protected SegmentReplicationShardStatsResponse shardOperation(SegmentReplicationStatsRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        ShardId shardId = shardRouting.shardId();
        if (!indexShard.indexSettings().isSegRepEnabled()) {
            return null;
        }
        if (shardRouting.primary()) {
            return new SegmentReplicationShardStatsResponse(this.pressureService.getStatsForShard(indexShard));
        }
        if (request.activeOnly()) {
            return new SegmentReplicationShardStatsResponse(this.targetService.getOngoingEventSegmentReplicationState(shardId));
        }
        return new SegmentReplicationShardStatsResponse(this.targetService.getSegmentReplicationState(shardId));
    }

    @Override
    protected ShardsIterator shards(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.routingTable().allShardsIncludingRelocationTargets(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, SegmentReplicationStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

