/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover.Condition;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class MaxDocsCondition
extends Condition<Long> {
    public static final String NAME = "max_docs";

    public MaxDocsCondition(Long value) {
        super(NAME);
        this.value = value;
    }

    public MaxDocsCondition(StreamInput in) throws IOException {
        super(NAME);
        this.value = in.readLong();
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        return new Condition.Result(this, (Long)this.value <= stats.numDocs);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong((Long)this.value);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, (Long)this.value);
    }

    public static MaxDocsCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_NUMBER) {
            return new MaxDocsCondition(parser.longValue());
        }
        throw new IllegalArgumentException("invalid token: " + parser.currentToken());
    }
}

