/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.shards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.CollectionUtil;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.health.ClusterShardHealth;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.ImmutableOpenIntMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.CountDown;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.AsyncShardFetch;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.TransportNodesListGatewayStartedShards;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportIndicesShardStoresAction
extends TransportClusterManagerNodeReadAction<IndicesShardStoresRequest, IndicesShardStoresResponse> {
    private static final Logger logger = LogManager.getLogger(TransportIndicesShardStoresAction.class);
    private final TransportNodesListGatewayStartedShards listShardStoresInfo;

    @Inject
    public TransportIndicesShardStoresAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportNodesListGatewayStartedShards listShardStoresInfo) {
        super("indices:monitor/shard_stores", transportService, clusterService, threadPool, actionFilters, IndicesShardStoresRequest::new, indexNameExpressionResolver);
        this.listShardStoresInfo = listShardStoresInfo;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected IndicesShardStoresResponse read(StreamInput in) throws IOException {
        return new IndicesShardStoresResponse(in);
    }

    @Override
    protected void clusterManagerOperation(IndicesShardStoresRequest request, ClusterState state, ActionListener<IndicesShardStoresResponse> listener) {
        RoutingTable routingTables = state.routingTable();
        RoutingNodes routingNodes = state.getRoutingNodes();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
        HashSet<Tuple<ShardId, String>> shardsToFetch = new HashSet<Tuple<ShardId, String>>();
        logger.trace("using cluster state version [{}] to determine shards", (Object)state.version());
        for (String index : concreteIndices) {
            IndexRoutingTable indexShardRoutingTables = routingTables.index(index);
            if (indexShardRoutingTables == null) continue;
            String customDataPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(state.metadata().index(index).getSettings());
            for (IndexShardRoutingTable routing : indexShardRoutingTables) {
                int shardId = routing.shardId().id();
                ClusterShardHealth shardHealth = new ClusterShardHealth(shardId, routing);
                if (!request.shardStatuses().contains(shardHealth.getStatus())) continue;
                shardsToFetch.add(Tuple.tuple(routing.shardId(), customDataPath));
            }
        }
        new AsyncShardStoresInfoFetches(state.nodes(), routingNodes, shardsToFetch, listener).start();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesShardStoresRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    private class AsyncShardStoresInfoFetches {
        private final DiscoveryNodes nodes;
        private final RoutingNodes routingNodes;
        private final Set<Tuple<ShardId, String>> shards;
        private final ActionListener<IndicesShardStoresResponse> listener;
        private CountDown expectedOps;
        private final Queue<InternalAsyncFetch.Response> fetchResponses;

        AsyncShardStoresInfoFetches(DiscoveryNodes nodes, RoutingNodes routingNodes, Set<Tuple<ShardId, String>> shards, ActionListener<IndicesShardStoresResponse> listener) {
            this.nodes = nodes;
            this.routingNodes = routingNodes;
            this.shards = shards;
            this.listener = listener;
            this.fetchResponses = new ConcurrentLinkedQueue<InternalAsyncFetch.Response>();
            this.expectedOps = new CountDown(shards.size());
        }

        void start() {
            if (this.shards.isEmpty()) {
                this.listener.onResponse(new IndicesShardStoresResponse());
            } else {
                for (Tuple<ShardId, String> shard : this.shards) {
                    InternalAsyncFetch fetch = new InternalAsyncFetch(logger, "shard_stores", shard.v1(), shard.v2(), TransportIndicesShardStoresAction.this.listShardStoresInfo);
                    fetch.fetchData(this.nodes, Collections.emptySet());
                }
            }
        }

        private class InternalAsyncFetch
        extends AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> {
            InternalAsyncFetch(Logger logger, String type, ShardId shardId, String customDataPath, TransportNodesListGatewayStartedShards action) {
                super(logger, type, shardId, customDataPath, action);
            }

            @Override
            protected synchronized void processAsyncFetch(List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures, long fetchingRound) {
                AsyncShardStoresInfoFetches.this.fetchResponses.add(new Response(this.shardId, responses, failures));
                if (AsyncShardStoresInfoFetches.this.expectedOps.countDown()) {
                    this.finish();
                }
            }

            void finish() {
                HashMap<String, ImmutableOpenIntMap<List<IndicesShardStoresResponse.StoreStatus>>> indicesStoreStatusesBuilder = new HashMap<String, ImmutableOpenIntMap<List<IndicesShardStoresResponse.StoreStatus>>>();
                ArrayList<IndicesShardStoresResponse.Failure> failureBuilder = new ArrayList<IndicesShardStoresResponse.Failure>();
                for (Response fetchResponse : AsyncShardStoresInfoFetches.this.fetchResponses) {
                    ImmutableOpenIntMap indexStoreStatuses = (ImmutableOpenIntMap)indicesStoreStatusesBuilder.get(fetchResponse.shardId.getIndexName());
                    ImmutableOpenIntMap.Builder<ArrayList<Object>> indexShardsBuilder = indexStoreStatuses == null ? ImmutableOpenIntMap.builder() : ImmutableOpenIntMap.builder(indexStoreStatuses);
                    ArrayList<IndicesShardStoresResponse.StoreStatus> storeStatuses = (ArrayList<IndicesShardStoresResponse.StoreStatus>)indexShardsBuilder.get(fetchResponse.shardId.id());
                    if (storeStatuses == null) {
                        storeStatuses = new ArrayList<IndicesShardStoresResponse.StoreStatus>();
                    }
                    for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response : fetchResponse.responses) {
                        if (!this.shardExistsInNode(response)) continue;
                        IndicesShardStoresResponse.StoreStatus.AllocationStatus allocationStatus = this.getAllocationStatus(fetchResponse.shardId.getIndexName(), fetchResponse.shardId.id(), response.getNode());
                        storeStatuses.add(new IndicesShardStoresResponse.StoreStatus(response.getNode(), response.allocationId(), allocationStatus, response.storeException()));
                    }
                    CollectionUtil.timSort(storeStatuses);
                    indexShardsBuilder.put(fetchResponse.shardId.id(), storeStatuses);
                    indicesStoreStatusesBuilder.put(fetchResponse.shardId.getIndexName(), indexShardsBuilder.build());
                    for (FailedNodeException failure : fetchResponse.failures) {
                        failureBuilder.add(new IndicesShardStoresResponse.Failure(failure.nodeId(), fetchResponse.shardId.getIndexName(), fetchResponse.shardId.id(), failure.getCause()));
                    }
                }
                AsyncShardStoresInfoFetches.this.listener.onResponse(new IndicesShardStoresResponse(indicesStoreStatusesBuilder, Collections.unmodifiableList(failureBuilder)));
            }

            private IndicesShardStoresResponse.StoreStatus.AllocationStatus getAllocationStatus(String index, int shardID, DiscoveryNode node) {
                for (ShardRouting shardRouting : AsyncShardStoresInfoFetches.this.routingNodes.node(node.getId())) {
                    ShardId shardId = shardRouting.shardId();
                    if (shardId.id() != shardID || !shardId.getIndexName().equals(index)) continue;
                    if (shardRouting.primary()) {
                        return IndicesShardStoresResponse.StoreStatus.AllocationStatus.PRIMARY;
                    }
                    if (shardRouting.assignedToNode()) {
                        return IndicesShardStoresResponse.StoreStatus.AllocationStatus.REPLICA;
                    }
                    return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
                }
                return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
            }

            private boolean shardExistsInNode(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response) {
                return response.storeException() != null || response.allocationId() != null;
            }

            @Override
            protected void reroute(ShardId shardId, String reason) {
            }

            public class Response {
                private final ShardId shardId;
                private final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses;
                private final List<FailedNodeException> failures;

                Response(ShardId shardId, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
                    this.shardId = shardId;
                    this.responses = responses;
                    this.failures = failures;
                }
            }
        }
    }
}

