/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkItemResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.StatusToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParserUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;

public class BulkResponse
extends ActionResponse
implements Iterable<BulkItemResponse>,
StatusToXContentObject {
    private static final String ITEMS = "items";
    private static final String ERRORS = "errors";
    private static final String TOOK = "took";
    private static final String INGEST_TOOK = "ingest_took";
    public static final long NO_INGEST_TOOK = -1L;
    private final BulkItemResponse[] responses;
    private final long tookInMillis;
    private final long ingestTookInMillis;

    public BulkResponse(StreamInput in) throws IOException {
        super(in);
        this.responses = in.readArray(BulkItemResponse::new, BulkItemResponse[]::new);
        this.tookInMillis = in.readVLong();
        this.ingestTookInMillis = in.readZLong();
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis) {
        this(responses, tookInMillis, -1L);
    }

    public BulkResponse(BulkItemResponse[] responses, long tookInMillis, long ingestTookInMillis) {
        this.responses = responses;
        this.tookInMillis = tookInMillis;
        this.ingestTookInMillis = ingestTookInMillis;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public TimeValue getIngestTook() {
        return new TimeValue(this.ingestTookInMillis);
    }

    public long getIngestTookInMillis() {
        return this.ingestTookInMillis;
    }

    public boolean hasFailures() {
        for (BulkItemResponse response : this.responses) {
            if (!response.isFailed()) continue;
            return true;
        }
        return false;
    }

    public String buildFailureMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("failure in bulk execution:");
        for (int i = 0; i < this.responses.length; ++i) {
            BulkItemResponse response = this.responses[i];
            if (!response.isFailed()) continue;
            sb.append("\n[").append(i).append("]: index [").append(response.getIndex()).append("], id [").append(response.getId()).append("], message [").append(response.getFailureMessage()).append("]");
        }
        return sb.toString();
    }

    public BulkItemResponse[] getItems() {
        return this.responses;
    }

    @Override
    public Iterator<BulkItemResponse> iterator() {
        return Arrays.stream(this.responses).iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.responses);
        out.writeVLong(this.tookInMillis);
        out.writeZLong(this.ingestTookInMillis);
    }

    @Override
    public RestStatus status() {
        return RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOOK, this.tookInMillis);
        if (this.ingestTookInMillis != -1L) {
            builder.field(INGEST_TOOK, this.ingestTookInMillis);
        }
        builder.field(ERRORS, this.hasFailures());
        builder.startArray(ITEMS);
        for (BulkItemResponse item : this) {
            item.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static BulkResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        long took = -1L;
        long ingestTook = -1L;
        ArrayList<BulkItemResponse> items = new ArrayList<BulkItemResponse>();
        String currentFieldName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (TOOK.equals(currentFieldName)) {
                    took = parser.longValue();
                    continue;
                }
                if (INGEST_TOOK.equals(currentFieldName)) {
                    ingestTook = parser.longValue();
                    continue;
                }
                if (ERRORS.equals(currentFieldName)) continue;
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (ITEMS.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        items.add(BulkItemResponse.fromXContent(parser, items.size()));
                    }
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
        }
        return new BulkResponse(items.toArray(new BulkItemResponse[items.size()]), took, ingestTook);
    }
}

