/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.get;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.RoutingMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.single.shard.TransportSingleShardAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.get.GetResult;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportGetAction
extends TransportSingleShardAction<GetRequest, GetResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/get", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(GetRequest request) {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((GetRequest)request.request()).id(), ((GetRequest)request.request()).routing(), ((GetRequest)request.request()).preference());
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((GetRequest)request.request()).routing(state.metadata().resolveIndexRouting(((GetRequest)request.request()).routing(), ((GetRequest)request.request()).index()));
        if (((GetRequest)request.request()).routing() == null && state.getMetadata().routingRequired(request.concreteIndex())) {
            throw new RoutingMissingException(request.concreteIndex(), ((GetRequest)request.request()).id());
        }
    }

    @Override
    protected void asyncShardOperation(GetRequest request, ShardId shardId, ActionListener<GetResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation(request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected GetResponse shardOperation(GetRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh("refresh_flag_get");
        }
        GetResult result = indexShard.getService().get(request.id(), request.storedFields(), request.realtime(), request.version(), request.versionType(), request.fetchSourceContext());
        return new GetResponse(result);
    }

    @Override
    protected Writeable.Reader<GetResponse> getResponseReader() {
        return GetResponse::new;
    }

    @Override
    protected String getExecutor(GetRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().getIndexSafe(shardId.getIndex()).isSystem()) {
            return "system_read";
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return "search_throttled";
        }
        return super.getExecutor(request, shardId);
    }
}

