/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.VersionType;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.ConfigurationUtils;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocument;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestService;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.Pipeline;

public class SimulatePipelineRequest
extends ActionRequest
implements ToXContentObject {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SimulatePipelineRequest.class);
    private String id;
    private boolean verbose;
    private BytesReference source;
    private XContentType xContentType;
    static final String SIMULATED_PIPELINE_ID = "_simulate_pipeline";

    public SimulatePipelineRequest(BytesReference source, XContentType xContentType) {
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
    }

    SimulatePipelineRequest() {
    }

    SimulatePipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        this.verbose = in.readBoolean();
        this.source = in.readBytesReference();
        this.xContentType = in.readEnum(XContentType.class);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        out.writeBoolean(this.verbose);
        out.writeBytesReference(this.source);
        out.writeEnum(this.xContentType);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.rawValue(this.source.streamInput(), this.xContentType);
        return builder;
    }

    static Parsed parseWithPipelineId(String pipelineId, Map<String, Object> config, boolean verbose, IngestService ingestService) {
        if (pipelineId == null) {
            throw new IllegalArgumentException("param [pipeline] is null");
        }
        Pipeline pipeline = ingestService.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline [" + pipelineId + "] does not exist");
        }
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    static Parsed parse(Map<String, Object> config, boolean verbose, IngestService ingestService) throws Exception {
        Map<String, Object> pipelineConfig = ConfigurationUtils.readMap(null, null, config, "pipeline");
        Pipeline pipeline = Pipeline.create(SIMULATED_PIPELINE_ID, pipelineConfig, ingestService.getProcessorFactories(), ingestService.getScriptService());
        List<IngestDocument> ingestDocumentList = SimulatePipelineRequest.parseDocs(config);
        return new Parsed(pipeline, ingestDocumentList, verbose);
    }

    private static List<IngestDocument> parseDocs(Map<String, Object> config) {
        List docs = ConfigurationUtils.readList(null, null, config, "docs");
        if (docs.isEmpty()) {
            throw new IllegalArgumentException("must specify at least one document in [docs]");
        }
        ArrayList<IngestDocument> ingestDocumentList = new ArrayList<IngestDocument>();
        for (Object object : docs) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("malformed [docs] section, should include an inner object");
            }
            Map dataMap = (Map)object;
            Map<String, Object> document = ConfigurationUtils.readMap(null, null, dataMap, "_source");
            String index = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.INDEX.getFieldName(), "_index");
            String id = ConfigurationUtils.readStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.ID.getFieldName(), "_id");
            String routing = ConfigurationUtils.readOptionalStringOrIntProperty(null, null, dataMap, IngestDocument.Metadata.ROUTING.getFieldName());
            Long version = null;
            if (dataMap.containsKey(IngestDocument.Metadata.VERSION.getFieldName())) {
                version = (Long)ConfigurationUtils.readObject(null, null, dataMap, IngestDocument.Metadata.VERSION.getFieldName());
            }
            VersionType versionType = null;
            if (dataMap.containsKey(IngestDocument.Metadata.VERSION_TYPE.getFieldName())) {
                versionType = VersionType.fromString(ConfigurationUtils.readStringProperty(null, null, dataMap, IngestDocument.Metadata.VERSION_TYPE.getFieldName()));
            }
            IngestDocument ingestDocument = new IngestDocument(index, id, routing, version, versionType, document);
            if (dataMap.containsKey(IngestDocument.Metadata.IF_SEQ_NO.getFieldName())) {
                Long ifSeqNo = (Long)ConfigurationUtils.readObject(null, null, dataMap, IngestDocument.Metadata.IF_SEQ_NO.getFieldName());
                ingestDocument.setFieldValue(IngestDocument.Metadata.IF_SEQ_NO.getFieldName(), ifSeqNo);
            }
            if (dataMap.containsKey(IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName())) {
                Long ifPrimaryTerm = (Long)ConfigurationUtils.readObject(null, null, dataMap, IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName());
                ingestDocument.setFieldValue(IngestDocument.Metadata.IF_PRIMARY_TERM.getFieldName(), ifPrimaryTerm);
            }
            ingestDocumentList.add(ingestDocument);
        }
        return ingestDocumentList;
    }

    static class Parsed {
        private final List<IngestDocument> documents;
        private final Pipeline pipeline;
        private final boolean verbose;

        Parsed(Pipeline pipeline, List<IngestDocument> documents, boolean verbose) {
            this.pipeline = pipeline;
            this.documents = Collections.unmodifiableList(documents);
            this.verbose = verbose;
        }

        public Pipeline getPipeline() {
            return this.pipeline;
        }

        public List<IngestDocument> getDocuments() {
            return this.documents;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }

    public static final class Fields {
        static final String PIPELINE = "pipeline";
        static final String DOCS = "docs";
        static final String SOURCE = "_source";
    }
}

