/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.ingest;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocument;

final class WriteableIngestDocument
implements Writeable,
ToXContentFragment {
    static final String SOURCE_FIELD = "_source";
    static final String INGEST_FIELD = "_ingest";
    static final String DOC_FIELD = "doc";
    private final IngestDocument ingestDocument;
    public static final ConstructingObjectParser<WriteableIngestDocument, Void> INGEST_DOC_PARSER = new ConstructingObjectParser("ingest_document", true, a -> {
        HashMap<String, Object> sourceAndMetadata = new HashMap<String, Object>();
        sourceAndMetadata.put(IngestDocument.Metadata.INDEX.getFieldName(), a[0]);
        sourceAndMetadata.put(IngestDocument.Metadata.ID.getFieldName(), a[1]);
        if (a[2] != null) {
            sourceAndMetadata.put(IngestDocument.Metadata.ROUTING.getFieldName(), a[2]);
        }
        if (a[3] != null) {
            sourceAndMetadata.put(IngestDocument.Metadata.VERSION.getFieldName(), a[3]);
        }
        if (a[4] != null) {
            sourceAndMetadata.put(IngestDocument.Metadata.VERSION_TYPE.getFieldName(), a[4]);
        }
        sourceAndMetadata.putAll((Map)a[5]);
        return new WriteableIngestDocument(new IngestDocument(sourceAndMetadata, (Map)a[6]));
    });
    public static final ConstructingObjectParser<WriteableIngestDocument, Void> PARSER;

    WriteableIngestDocument(IngestDocument ingestDocument) {
        assert (ingestDocument != null);
        this.ingestDocument = ingestDocument;
    }

    WriteableIngestDocument(StreamInput in) throws IOException {
        Map<String, Object> sourceAndMetadata = in.readMap();
        Map<String, Object> ingestMetadata = in.readMap();
        this.ingestDocument = new IngestDocument(sourceAndMetadata, ingestMetadata);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.ingestDocument.getSourceAndMetadata());
        out.writeMap(this.ingestDocument.getIngestMetadata());
    }

    IngestDocument getIngestDocument() {
        return this.ingestDocument;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(DOC_FIELD);
        Map<IngestDocument.Metadata, Object> metadataMap = this.ingestDocument.getMetadata();
        for (Map.Entry<IngestDocument.Metadata, Object> metadata : metadataMap.entrySet()) {
            if (metadata.getValue() == null) continue;
            builder.field(metadata.getKey().getFieldName(), metadata.getValue().toString());
        }
        Map<String, Object> source = IngestDocument.deepCopyMap(this.ingestDocument.getSourceAndMetadata());
        metadataMap.keySet().forEach(mD -> source.remove(mD.getFieldName()));
        builder.field(SOURCE_FIELD, source);
        builder.field(INGEST_FIELD, this.ingestDocument.getIngestMetadata());
        builder.endObject();
        return builder;
    }

    public static WriteableIngestDocument fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteableIngestDocument that = (WriteableIngestDocument)o;
        return Objects.equals(this.ingestDocument, that.ingestDocument);
    }

    public int hashCode() {
        return Objects.hash(this.ingestDocument);
    }

    public String toString() {
        return this.ingestDocument.toString();
    }

    static {
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(IngestDocument.Metadata.INDEX.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(IngestDocument.Metadata.ID.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(IngestDocument.Metadata.ROUTING.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField(IngestDocument.Metadata.VERSION.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(IngestDocument.Metadata.VERSION_TYPE.getFieldName(), new String[0]));
        INGEST_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField(SOURCE_FIELD, new String[0]));
        INGEST_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            Map<String, Object> ingestMap = p.map();
            ingestMap.computeIfPresent("timestamp", (k, o) -> ZonedDateTime.parse((String)o));
            return ingestMap;
        }, new ParseField(INGEST_FIELD, new String[0]));
        PARSER = new ConstructingObjectParser("writeable_ingest_document", true, a -> (WriteableIngestDocument)a[0]);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), INGEST_DOC_PARSER, new ParseField(DOC_FIELD, new String[0]));
    }
}

