/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.StepListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DeletePitInfo;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DeletePitResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.GetAllPitNodesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.GetAllPitNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.PitSearchContextIdForNode;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchContextId;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTransportService;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchUtils;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.GroupedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transport;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class PitService {
    private static final Logger logger = LogManager.getLogger(PitService.class);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final TransportService transportService;
    private final NodeClient nodeClient;

    @Inject
    public PitService(ClusterService clusterService, SearchTransportService searchTransportService, TransportService transportService, NodeClient nodeClient) {
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.transportService = transportService;
        this.nodeClient = nodeClient;
    }

    public void deletePitContexts(Map<String, List<PitSearchContextIdForNode>> nodeToContextsMap, ActionListener<DeletePitResponse> listener) {
        if (nodeToContextsMap.size() == 0) {
            listener.onResponse(new DeletePitResponse(Collections.emptyList()));
        }
        Set<String> clusters = nodeToContextsMap.values().stream().flatMap(Collection::stream).filter(ctx -> !Strings.isEmpty(ctx.getSearchContextIdForNode().getClusterAlias())).map(c -> c.getSearchContextIdForNode().getClusterAlias()).collect(Collectors.toSet());
        StepListener lookupListener = (StepListener)SearchUtils.getConnectionLookupListener(this.searchTransportService.getRemoteClusterService(), this.clusterService.state(), clusters);
        lookupListener.whenComplete(nodeLookup -> {
            GroupedActionListener<DeletePitResponse> groupedListener = this.getDeletePitGroupedListener(listener, nodeToContextsMap.size());
            for (Map.Entry entry : nodeToContextsMap.entrySet()) {
                String clusterAlias = ((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getClusterAlias();
                DiscoveryNode node = (DiscoveryNode)nodeLookup.apply(clusterAlias, ((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode());
                if (node == null) {
                    node = this.clusterService.state().getNodes().get(((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode());
                }
                if (node == null) {
                    logger.error(() -> new ParameterizedMessage("node [{}] not found", (Object)((PitSearchContextIdForNode)((List)entry.getValue()).get(0)).getSearchContextIdForNode().getNode()));
                    ArrayList<DeletePitInfo> deletePitInfos = new ArrayList<DeletePitInfo>();
                    for (PitSearchContextIdForNode pitSearchContextIdForNode : (List)entry.getValue()) {
                        deletePitInfos.add(new DeletePitInfo(false, pitSearchContextIdForNode.getPitId()));
                    }
                    groupedListener.onResponse(new DeletePitResponse(deletePitInfos));
                    continue;
                }
                try {
                    Transport.Connection connection = this.searchTransportService.getConnection(clusterAlias, node);
                    this.searchTransportService.sendFreePITContexts(connection, (List)entry.getValue(), groupedListener);
                }
                catch (Exception e) {
                    String nodeName = node.getName();
                    logger.error(() -> new ParameterizedMessage("Delete PITs failed on node [{}]", (Object)nodeName), (Throwable)e);
                    ArrayList<DeletePitInfo> deletePitInfos = new ArrayList<DeletePitInfo>();
                    for (PitSearchContextIdForNode pitSearchContextIdForNode : (List)entry.getValue()) {
                        deletePitInfos.add(new DeletePitInfo(false, pitSearchContextIdForNode.getPitId()));
                    }
                    groupedListener.onResponse(new DeletePitResponse(deletePitInfos));
                }
            }
        }, listener::onFailure);
    }

    public GroupedActionListener<DeletePitResponse> getDeletePitGroupedListener(final ActionListener<DeletePitResponse> listener, int size) {
        return new GroupedActionListener<DeletePitResponse>(new ActionListener<Collection<DeletePitResponse>>(){

            @Override
            public void onResponse(Collection<DeletePitResponse> responses) {
                HashMap<String, Boolean> pitIdToSucceededMap = new HashMap<String, Boolean>();
                for (DeletePitResponse deletePitResponse : responses) {
                    for (DeletePitInfo deletePitInfo : deletePitResponse.getDeletePitResults()) {
                        if (!pitIdToSucceededMap.containsKey(deletePitInfo.getPitId())) {
                            pitIdToSucceededMap.put(deletePitInfo.getPitId(), deletePitInfo.isSuccessful());
                        }
                        if (deletePitInfo.isSuccessful()) continue;
                        logger.debug(() -> new ParameterizedMessage("Deleting PIT with ID {} failed ", (Object)deletePitInfo.getPitId()));
                        pitIdToSucceededMap.put(deletePitInfo.getPitId(), deletePitInfo.isSuccessful());
                    }
                }
                ArrayList<DeletePitInfo> deletePitResults = new ArrayList<DeletePitInfo>();
                for (Map.Entry entry : pitIdToSucceededMap.entrySet()) {
                    deletePitResults.add(new DeletePitInfo((Boolean)entry.getValue(), (String)entry.getKey()));
                }
                DeletePitResponse deletePitResponse = new DeletePitResponse(deletePitResults);
                listener.onResponse(deletePitResponse);
            }

            @Override
            public void onFailure(Exception e) {
                logger.error("Delete PITs failed", (Throwable)e);
                listener.onFailure(e);
            }
        }, size);
    }

    public Map<String, String[]> getIndicesForPits(List<String> pitIds) {
        HashMap<String, String[]> pitToIndicesMap = new HashMap<String, String[]>();
        for (String pitId : pitIds) {
            pitToIndicesMap.put(pitId, SearchContextId.decode(this.nodeClient.getNamedWriteableRegistry(), pitId).getActualIndices());
        }
        return pitToIndicesMap;
    }

    public void getAllPits(final ActionListener<GetAllPitNodesResponse> getAllPitsListener) {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : this.clusterService.state().nodes().getDataNodes().values()) {
            nodes.add(node);
        }
        DiscoveryNode[] disNodesArr = nodes.toArray(new DiscoveryNode[nodes.size()]);
        GetAllPitNodesRequest getAllPitNodesRequest = new GetAllPitNodesRequest(disNodesArr);
        this.transportService.sendRequest(this.transportService.getLocalNode(), "indices:data/read/point_in_time/readall", getAllPitNodesRequest, new TransportResponseHandler<GetAllPitNodesResponse>(){

            @Override
            public void handleResponse(GetAllPitNodesResponse response) {
                getAllPitsListener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                getAllPitsListener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public GetAllPitNodesResponse read(StreamInput in) throws IOException {
                return new GetAllPitNodesResponse(in);
            }
        });
    }
}

