/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopFieldDocs;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.AbstractSearchAsyncAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.BottomSortValuesCollector;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.FetchSearchPhase;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.QueryPhaseResultConsumer;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhase;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseController;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseResults;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchProgressListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTask;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTransportService;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.TransportSearchAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.GroupShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchPhaseResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchShardTarget;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.AliasFilter;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transport;

class SearchQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<SearchPhaseResult> {
    private final SearchPhaseController searchPhaseController;
    private final SearchProgressListener progressListener;
    private final int topDocsSize;
    private final int trackTotalHitsUpTo;
    private volatile BottomSortValuesCollector bottomSortCollector;

    SearchQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, QueryPhaseResultConsumer resultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters) {
        super("query", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, resultConsumer, request.getMaxConcurrentShardRequests(), clusters);
        this.topDocsSize = SearchPhaseController.getTopDocsSize(request);
        this.trackTotalHitsUpTo = request.resolveTrackTotalHitsUpTo();
        this.searchPhaseController = searchPhaseController;
        this.progressListener = task.getProgressListener();
        this.addReleasable(resultConsumer);
        boolean hasFetchPhase = request.source() == null ? true : request.source().size() > 0;
        this.progressListener.notifyListShards(SearchProgressListener.buildSearchShards(this.shardsIts), SearchProgressListener.buildSearchShards(this.toSkipShardsIts), clusters, hasFetchPhase);
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<SearchPhaseResult> listener) {
        ShardSearchRequest request = this.rewriteShardSearchRequest(super.buildShardSearchRequest(shardIt));
        if (request != null) {
            request.setInboundNetworkTime(System.currentTimeMillis());
        }
        this.getSearchTransport().sendExecuteQuery(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), request, this.getTask(), listener);
    }

    @Override
    protected void onShardGroupFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        this.progressListener.notifyQueryFailure(shardIndex, shardTarget, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onShardResult(SearchPhaseResult result, SearchShardIterator shardIt) {
        QuerySearchResult queryResult = result.queryResult();
        if (!queryResult.isNull() && this.getRequest().scroll() == null && queryResult.topDocs() != null && queryResult.topDocs().topDocs.getClass() == TopFieldDocs.class) {
            TopFieldDocs topDocs = (TopFieldDocs)queryResult.topDocs().topDocs;
            if (this.bottomSortCollector == null) {
                SearchQueryThenFetchAsyncAction searchQueryThenFetchAsyncAction = this;
                synchronized (searchQueryThenFetchAsyncAction) {
                    if (this.bottomSortCollector == null) {
                        this.bottomSortCollector = new BottomSortValuesCollector(this.topDocsSize, topDocs.fields);
                    }
                }
            }
            this.bottomSortCollector.consumeTopDocs(topDocs, queryResult.sortValueFormats());
        }
        super.onShardResult(result, shardIt);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<SearchPhaseResult> results, SearchPhaseContext context) {
        return new FetchSearchPhase(results, this.searchPhaseController, null, this);
    }

    private ShardSearchRequest rewriteShardSearchRequest(ShardSearchRequest request) {
        if (this.bottomSortCollector == null) {
            return request;
        }
        if (this.trackTotalHitsUpTo != Integer.MAX_VALUE && this.bottomSortCollector.getTotalHits() > (long)this.trackTotalHitsUpTo) {
            request.source(request.source().shallowCopy().trackTotalHits(false));
        }
        if (this.bottomSortCollector.getBottomSortValues() != null) {
            request.setBottomSortValues(this.bottomSortCollector.getBottomSortValues());
        }
        return request;
    }
}

