/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.IntArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.ParsedScrollId;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhase;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseController;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseName;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchScrollAsyncAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchScrollRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTask;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTransportService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AtomicArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.CountDown;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchShardTarget;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.ShardFetchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.InternalScrollSearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ScrollQuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transport;

final class SearchScrollQueryThenFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQuerySearchResult> {
    private final SearchTask task;
    private final AtomicArray<FetchSearchResult> fetchResults;
    private final AtomicArray<QuerySearchResult> queryResults;

    SearchScrollQueryThenFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, searchPhaseController, request, searchTransportService);
        this.task = task;
        this.fetchResults = new AtomicArray(scrollId.getContext().length);
        this.queryResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQuerySearchResult result) {
        this.queryResults.setOnce(shardId, result.queryResult());
    }

    @Override
    protected void executeInitialPhase(Transport.Connection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQuerySearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollQuery(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(final BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return new SearchPhase(SearchPhaseName.FETCH.getName()){

            @Override
            public void run() {
                final SearchPhaseController.ReducedQueryPhase reducedQueryPhase = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.reducedScrollQueryPhase(SearchScrollQueryThenFetchAsyncAction.this.queryResults.asList());
                ScoreDoc[] scoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
                if (scoreDocs.length == 0) {
                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                    return;
                }
                IntArrayList[] docIdsToLoad = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.fillDocIdsToLoad(SearchScrollQueryThenFetchAsyncAction.this.queryResults.length(), scoreDocs);
                ScoreDoc[] lastEmittedDocPerShard = SearchScrollQueryThenFetchAsyncAction.this.searchPhaseController.getLastEmittedDocPerShard(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.queryResults.length());
                final CountDown counter = new CountDown(docIdsToLoad.length);
                for (int i = 0; i < docIdsToLoad.length; ++i) {
                    int index = i;
                    IntArrayList docIds = docIdsToLoad[index];
                    if (docIds != null) {
                        final QuerySearchResult querySearchResult = SearchScrollQueryThenFetchAsyncAction.this.queryResults.get(index);
                        ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[index];
                        ShardFetchRequest shardFetchRequest = new ShardFetchRequest(querySearchResult.getContextId(), docIds, lastEmittedDoc);
                        SearchShardTarget searchShardTarget = querySearchResult.getSearchShardTarget();
                        DiscoveryNode node = (DiscoveryNode)clusterNodeLookup.apply(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                        assert (node != null) : "target node is null in secondary phase";
                        Transport.Connection connection = SearchScrollQueryThenFetchAsyncAction.this.getConnection(searchShardTarget.getClusterAlias(), node);
                        SearchScrollQueryThenFetchAsyncAction.this.searchTransportService.sendExecuteFetchScroll(connection, shardFetchRequest, SearchScrollQueryThenFetchAsyncAction.this.task, new SearchActionListener<FetchSearchResult>(querySearchResult.getSearchShardTarget(), index){

                            @Override
                            protected void innerOnResponse(FetchSearchResult response) {
                                SearchScrollQueryThenFetchAsyncAction.this.fetchResults.setOnce(response.getShardIndex(), response);
                                if (counter.countDown()) {
                                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                                }
                            }

                            @Override
                            public void onFailure(Exception t) {
                                SearchScrollQueryThenFetchAsyncAction.this.onShardFailure(this.getName(), counter, querySearchResult.getContextId(), t, querySearchResult.getSearchShardTarget(), () -> SearchScrollQueryThenFetchAsyncAction.this.sendResponsePhase(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults));
                            }
                        });
                        continue;
                    }
                    if (!counter.countDown()) continue;
                    SearchScrollQueryThenFetchAsyncAction.this.sendResponse(reducedQueryPhase, SearchScrollQueryThenFetchAsyncAction.this.fetchResults);
                }
            }
        };
    }
}

