/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.bootstrap;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.CreationException;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.spi.Message;

final class StartupException
extends RuntimeException {
    static final int STACKTRACE_LIMIT = 30;
    static final String GUICE_PACKAGE = "org.graylog.shaded.opensearch2.org.opensearch.common.inject";

    StartupException(Throwable cause) {
        super(cause);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(s::println);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(s::println);
    }

    private void printStackTrace(Consumer<String> consumer) {
        String basePath;
        Throwable originalCause = this.getCause();
        Throwable cause = originalCause;
        if (cause instanceof CreationException) {
            cause = StartupException.getFirstGuiceCause((CreationException)cause);
        }
        String message = cause.toString();
        consumer.accept(message);
        if (cause != null) {
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause != originalCause && !message.equals(cause.toString())) {
                consumer.accept("Likely root cause: " + cause);
            }
            StackTraceElement[] stack = cause.getStackTrace();
            int linesWritten = 0;
            for (int i = 0; i < stack.length; ++i) {
                if (linesWritten == 30) {
                    consumer.accept("\t<<<truncated>>>");
                    break;
                }
                String line = stack[i].toString();
                if (line.startsWith(GUICE_PACKAGE)) {
                    while (i + 1 < stack.length && stack[i + 1].toString().startsWith(GUICE_PACKAGE)) {
                        ++i;
                    }
                    consumer.accept("\tat <<<guice>>>");
                    ++linesWritten;
                    continue;
                }
                consumer.accept("\tat " + line);
                ++linesWritten;
            }
        }
        if (!(originalCause instanceof CreationException) && (basePath = System.getProperty("opensearch.logs.base_path")) != null) {
            String logPath = System.getProperty("opensearch.logs.base_path") + System.getProperty("file.separator") + System.getProperty("opensearch.logs.cluster_name") + ".log";
            consumer.accept("For complete error details, refer to the log at " + logPath);
        }
    }

    static Throwable getFirstGuiceCause(CreationException guice) {
        for (Message message : guice.getErrorMessages()) {
            Throwable cause = message.getCause();
            if (cause == null) continue;
            return cause;
        }
        return guice;
    }
}

