/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.io.IOException;
import java.util.Collections;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.DeletePipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.GetPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.GetPipelineResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.PutPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulatePipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulatePipelineResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.Cancellable;
import org.graylog.shaded.opensearch2.org.opensearch.client.IngestRequestConverters;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestHighLevelClient;

public final class IngestClient {
    private final RestHighLevelClient restHighLevelClient;

    IngestClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putPipeline(PutPipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putPipelineAsync(PutPipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetPipelineResponse getPipeline(GetPipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, Collections.singleton(404));
    }

    public Cancellable getPipelineAsync(GetPipelineRequest request, RequestOptions options, ActionListener<GetPipelineResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, listener, Collections.singleton(404));
    }

    public AcknowledgedResponse deletePipeline(DeletePipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deletePipelineAsync(DeletePipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public SimulatePipelineResponse simulate(SimulatePipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, IngestRequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable simulateAsync(SimulatePipelineRequest request, RequestOptions options, ActionListener<SimulatePipelineResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, IngestRequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, listener, Collections.emptySet());
    }
}

