/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.alias.Alias;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardCount;
import org.graylog.shaded.opensearch2.org.opensearch.client.TimedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.Validatable;
import org.graylog.shaded.opensearch2.org.opensearch.client.ValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.CreateIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class ResizeRequest
extends TimedRequest
implements Validatable,
ToXContentObject {
    private ActiveShardCount waitForActiveShards;
    private final String sourceIndex;
    private final String targetIndex;
    private Settings settings = Settings.EMPTY;
    private Set<Alias> aliases = new HashSet<Alias>();
    private ByteSizeValue maxShardSize;

    public ResizeRequest(String targetIndex, String sourceIndex) {
        this.targetIndex = Objects.requireNonNull(targetIndex);
        this.sourceIndex = Objects.requireNonNull(sourceIndex);
    }

    public ResizeRequest setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ResizeRequest setAliases(List<Alias> aliases) {
        this.aliases.clear();
        this.aliases.addAll(aliases);
        return this;
    }

    public Set<Alias> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (!this.settings.getByPrefix("index.sort.").isEmpty()) {
            validationException.addValidationError("can't override index sort when resizing an index");
        }
        return validationException.validationErrors().isEmpty() ? Optional.empty() : Optional.of(validationException);
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public ResizeRequest setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public ResizeRequest setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public void setMaxShardSize(ByteSizeValue maxShardSize) {
        this.maxShardSize = maxShardSize;
    }

    public ByteSizeValue getMaxShardSize() {
        return this.maxShardSize;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(CreateIndexRequest.SETTINGS.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(CreateIndexRequest.ALIASES.getPreferredName());
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

