/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.action.shard;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterManagerNodeChangePredicate;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateObserver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateTaskConfig;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateTaskExecutor;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateTaskListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.NotClusterManagerException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.FailedToCommitClusterStateException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RerouteService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocationService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.FailedShard;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.StaleShard;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ConnectTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.EmptyTransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestDeduplicator;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class ShardStateAction {
    private static final Logger logger = LogManager.getLogger(ShardStateAction.class);
    public static final String SHARD_STARTED_ACTION_NAME = "internal:cluster/shard/started";
    public static final String SHARD_FAILED_ACTION_NAME = "internal:cluster/shard/failure";
    public static final Setting<Priority> FOLLOW_UP_REROUTE_PRIORITY_SETTING = new Setting<Priority>("cluster.routing.allocation.shard_state.reroute.priority", Priority.NORMAL.toString(), ShardStateAction::parseReroutePriority, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated);
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private volatile Priority followUpRerouteTaskPriority;
    private final TransportRequestDeduplicator<FailedShardEntry> remoteFailedShardsDeduplicator = new TransportRequestDeduplicator();
    private static Class[] CLUSTER_MANAGER_CHANNEL_EXCEPTIONS = new Class[]{NotClusterManagerException.class, ConnectTransportException.class, FailedToCommitClusterStateException.class};

    private static Priority parseReroutePriority(String priorityString) {
        Priority priority = Priority.valueOf(priorityString.toUpperCase(Locale.ROOT));
        switch (priority) {
            case NORMAL: 
            case HIGH: 
            case URGENT: {
                return priority;
            }
        }
        throw new IllegalArgumentException("priority [" + priority + "] not supported for [" + FOLLOW_UP_REROUTE_PRIORITY_SETTING.getKey() + "]");
    }

    @Inject
    public ShardStateAction(ClusterService clusterService, TransportService transportService, AllocationService allocationService, RerouteService rerouteService, ThreadPool threadPool) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.followUpRerouteTaskPriority = FOLLOW_UP_REROUTE_PRIORITY_SETTING.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FOLLOW_UP_REROUTE_PRIORITY_SETTING, this::setFollowUpRerouteTaskPriority);
        transportService.registerRequestHandler(SHARD_STARTED_ACTION_NAME, "same", StartedShardEntry::new, new ShardStartedTransportHandler(clusterService, new ShardStartedClusterStateTaskExecutor(allocationService, rerouteService, () -> this.followUpRerouteTaskPriority, logger), logger));
        transportService.registerRequestHandler(SHARD_FAILED_ACTION_NAME, "same", FailedShardEntry::new, new ShardFailedTransportHandler(clusterService, new ShardFailedClusterStateTaskExecutor(allocationService, rerouteService, () -> this.followUpRerouteTaskPriority, logger), logger));
    }

    private void sendShardAction(final String actionName, ClusterState currentState, final TransportRequest request, final ActionListener<Void> listener) {
        final ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, logger, this.threadPool.getThreadContext());
        final DiscoveryNode clusterManagerNode = currentState.nodes().getClusterManagerNode();
        final Predicate<ClusterState> changePredicate = ClusterManagerNodeChangePredicate.build(currentState);
        if (clusterManagerNode == null) {
            logger.warn("no cluster-manager known for action [{}] for shard entry [{}]", (Object)actionName, (Object)request);
            this.waitForNewClusterManagerAndRetry(actionName, observer, request, listener, changePredicate);
        } else {
            logger.debug("sending [{}] to [{}] for shard entry [{}]", (Object)actionName, (Object)clusterManagerNode.getId(), (Object)request);
            this.transportService.sendRequest(clusterManagerNode, actionName, request, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    listener.onResponse(null);
                }

                @Override
                public void handleException(TransportException exp) {
                    if (ShardStateAction.isClusterManagerChannelException(exp)) {
                        ShardStateAction.this.waitForNewClusterManagerAndRetry(actionName, observer, request, listener, changePredicate);
                    } else {
                        logger.warn((Message)new ParameterizedMessage("unexpected failure while sending request [{}] to [{}] for shard entry [{}]", new Object[]{actionName, clusterManagerNode, request}), (Throwable)exp);
                        listener.onFailure(exp instanceof RemoteTransportException ? (Exception)(exp.getCause() instanceof Exception ? exp.getCause() : new OpenSearchException(exp.getCause())) : exp);
                    }
                }
            });
        }
    }

    private static boolean isClusterManagerChannelException(TransportException exp) {
        return ExceptionsHelper.unwrap(exp, CLUSTER_MANAGER_CHANNEL_EXCEPTIONS) != null;
    }

    public void remoteShardFailed(ShardId shardId, String allocationId, long primaryTerm, boolean markAsStale, String message, @Nullable Exception failure, ActionListener<Void> listener) {
        assert (primaryTerm > 0L) : "primary term should be strictly positive";
        this.remoteFailedShardsDeduplicator.executeOnce(new FailedShardEntry(shardId, allocationId, primaryTerm, message, failure, markAsStale), listener, (req, reqListener) -> this.sendShardAction(SHARD_FAILED_ACTION_NAME, this.clusterService.state(), (TransportRequest)req, (ActionListener<Void>)reqListener));
    }

    int remoteShardFailedCacheSize() {
        return this.remoteFailedShardsDeduplicator.size();
    }

    public void localShardFailed(ShardRouting shardRouting, String message, @Nullable Exception failure, ActionListener<Void> listener) {
        this.localShardFailed(shardRouting, message, failure, listener, this.clusterService.state());
    }

    public void localShardFailed(ShardRouting shardRouting, String message, @Nullable Exception failure, ActionListener<Void> listener, ClusterState currentState) {
        FailedShardEntry shardEntry = new FailedShardEntry(shardRouting.shardId(), shardRouting.allocationId().getId(), 0L, message, failure, true);
        this.sendShardAction(SHARD_FAILED_ACTION_NAME, currentState, shardEntry, listener);
    }

    protected void waitForNewClusterManagerAndRetry(final String actionName, ClusterStateObserver observer, final TransportRequest request, final ActionListener<Void> listener, Predicate<ClusterState> changePredicate) {
        observer.waitForNextChange(new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                if (logger.isTraceEnabled()) {
                    logger.trace("new cluster state [{}] after waiting for cluster-manager election for shard entry [{}]", (Object)state, (Object)request);
                }
                ShardStateAction.this.sendShardAction(actionName, state, request, listener);
            }

            @Override
            public void onClusterServiceClose() {
                logger.warn("node closed while execution action [{}] for shard entry [{}]", (Object)actionName, (Object)request);
                listener.onFailure(new NodeClosedException(ShardStateAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                assert (false);
            }
        }, changePredicate);
    }

    private void setFollowUpRerouteTaskPriority(Priority followUpRerouteTaskPriority) {
        this.followUpRerouteTaskPriority = followUpRerouteTaskPriority;
    }

    public void shardStarted(ShardRouting shardRouting, long primaryTerm, String message, ActionListener<Void> listener) {
        this.shardStarted(shardRouting, primaryTerm, message, listener, this.clusterService.state());
    }

    public void shardStarted(ShardRouting shardRouting, long primaryTerm, String message, ActionListener<Void> listener, ClusterState currentState) {
        StartedShardEntry entry = new StartedShardEntry(shardRouting.shardId(), shardRouting.allocationId().getId(), primaryTerm, message);
        this.sendShardAction(SHARD_STARTED_ACTION_NAME, currentState, entry, listener);
    }

    private static class ShardStartedTransportHandler
    implements TransportRequestHandler<StartedShardEntry> {
        private final ClusterService clusterService;
        private final ShardStartedClusterStateTaskExecutor shardStartedClusterStateTaskExecutor;
        private final Logger logger;

        ShardStartedTransportHandler(ClusterService clusterService, ShardStartedClusterStateTaskExecutor shardStartedClusterStateTaskExecutor, Logger logger) {
            this.clusterService = clusterService;
            this.shardStartedClusterStateTaskExecutor = shardStartedClusterStateTaskExecutor;
            this.logger = logger;
        }

        @Override
        public void messageReceived(StartedShardEntry request, TransportChannel channel, Task task) throws Exception {
            this.logger.debug("{} received shard started for [{}]", (Object)request.shardId, (Object)request);
            this.clusterService.submitStateUpdateTask("shard-started " + request, request, ClusterStateTaskConfig.build(Priority.URGENT), this.shardStartedClusterStateTaskExecutor, this.shardStartedClusterStateTaskExecutor);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class ShardStartedClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<StartedShardEntry>,
    ClusterStateTaskListener {
        private final AllocationService allocationService;
        private final Logger logger;
        private final RerouteService rerouteService;
        private final Supplier<Priority> prioritySupplier;

        public ShardStartedClusterStateTaskExecutor(AllocationService allocationService, RerouteService rerouteService, Supplier<Priority> prioritySupplier, Logger logger) {
            this.allocationService = allocationService;
            this.logger = logger;
            this.rerouteService = rerouteService;
            this.prioritySupplier = prioritySupplier;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<StartedShardEntry> execute(ClusterState currentState, List<StartedShardEntry> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<StartedShardEntry> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ArrayList<StartedShardEntry> tasksToBeApplied = new ArrayList<StartedShardEntry>();
            ArrayList<ShardRouting> shardRoutingsToBeApplied = new ArrayList<ShardRouting>(tasks.size());
            HashSet<ShardRouting> seenShardRoutings = new HashSet<ShardRouting>();
            for (StartedShardEntry task : tasks) {
                ShardRouting matched = currentState.getRoutingTable().getByAllocationId(task.shardId, task.allocationId);
                if (matched == null) {
                    this.logger.debug("{} ignoring shard started task [{}] (shard does not exist anymore)", (Object)task.shardId, (Object)task);
                    builder.success(task);
                    continue;
                }
                if (matched.primary() && task.primaryTerm > 0L) {
                    IndexMetadata indexMetadata = currentState.metadata().index(task.shardId.getIndex());
                    assert (indexMetadata != null);
                    long currentPrimaryTerm = indexMetadata.primaryTerm(task.shardId.id());
                    if (currentPrimaryTerm != task.primaryTerm) {
                        assert (currentPrimaryTerm > task.primaryTerm) : "received a primary term with a higher term than in the current cluster state (received [" + task.primaryTerm + "] but current is [" + currentPrimaryTerm + "])";
                        this.logger.debug("{} ignoring shard started task [{}] (primary term {} does not match current term {})", (Object)task.shardId, (Object)task, (Object)task.primaryTerm, (Object)currentPrimaryTerm);
                        builder.success(task);
                        continue;
                    }
                }
                if (!matched.initializing()) {
                    assert (matched.active()) : "expected active shard routing for task " + task + " but found " + matched;
                    this.logger.debug("{} ignoring shard started task [{}] (shard exists but is not initializing: {})", (Object)task.shardId, (Object)task, (Object)matched);
                    builder.success(task);
                    continue;
                }
                if (seenShardRoutings.contains(matched)) {
                    this.logger.trace("{} ignoring shard started task [{}] (already scheduled to start {})", (Object)task.shardId, (Object)task, (Object)matched);
                    tasksToBeApplied.add(task);
                    continue;
                }
                this.logger.debug("{} starting shard {} (shard started task: [{}])", (Object)task.shardId, (Object)matched, (Object)task);
                tasksToBeApplied.add(task);
                shardRoutingsToBeApplied.add(matched);
                seenShardRoutings.add(matched);
            }
            assert (tasksToBeApplied.size() >= shardRoutingsToBeApplied.size());
            ClusterState maybeUpdatedState = currentState;
            try {
                maybeUpdatedState = this.allocationService.applyStartedShards(currentState, shardRoutingsToBeApplied);
                builder.successes(tasksToBeApplied);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to apply started shards {}", (Object)shardRoutingsToBeApplied), (Throwable)e);
                builder.failures(tasksToBeApplied, e);
            }
            return builder.build(maybeUpdatedState);
        }

        @Override
        public void onFailure(String source, Exception e) {
            if (e instanceof FailedToCommitClusterStateException || e instanceof NotClusterManagerException) {
                this.logger.debug(() -> new ParameterizedMessage("failure during [{}]", (Object)source), (Throwable)e);
            } else {
                this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
            }
        }

        @Override
        public void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
            this.rerouteService.reroute("reroute after starting shards", this.prioritySupplier.get(), ActionListener.wrap(r -> this.logger.trace("reroute after starting shards succeeded"), e -> this.logger.debug("reroute after starting shards failed", (Throwable)e)));
        }
    }

    private static class ShardFailedTransportHandler
    implements TransportRequestHandler<FailedShardEntry> {
        private final ClusterService clusterService;
        private final ShardFailedClusterStateTaskExecutor shardFailedClusterStateTaskExecutor;
        private final Logger logger;

        ShardFailedTransportHandler(ClusterService clusterService, ShardFailedClusterStateTaskExecutor shardFailedClusterStateTaskExecutor, Logger logger) {
            this.clusterService = clusterService;
            this.shardFailedClusterStateTaskExecutor = shardFailedClusterStateTaskExecutor;
            this.logger = logger;
        }

        @Override
        public void messageReceived(final FailedShardEntry request, final TransportChannel channel, Task task) throws Exception {
            this.logger.debug(() -> new ParameterizedMessage("{} received shard failed for {}", (Object)request.shardId, (Object)request), (Throwable)request.failure);
            this.clusterService.submitStateUpdateTask("shard-failed", request, ClusterStateTaskConfig.build(Priority.HIGH), this.shardFailedClusterStateTaskExecutor, new ClusterStateTaskListener(){

                @Override
                public void onFailure(String source, Exception e) {
                    logger.error(() -> new ParameterizedMessage("{} unexpected failure while failing shard [{}]", (Object)request2.shardId, (Object)request), (Throwable)e);
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception channelException) {
                        channelException.addSuppressed(e);
                        logger.warn(() -> new ParameterizedMessage("{} failed to send failure [{}] while failing shard [{}]", new Object[]{request2.shardId, e, request}), (Throwable)channelException);
                    }
                }

                @Override
                public void onNoLongerClusterManager(String source) {
                    logger.error("{} no longer cluster-manager while failing shard [{}]", (Object)request.shardId, (Object)request);
                    try {
                        channel.sendResponse(new NotClusterManagerException(source));
                    }
                    catch (Exception channelException) {
                        logger.warn(() -> new ParameterizedMessage("{} failed to send no longer cluster-manager while failing shard [{}]", (Object)request2.shardId, (Object)request), (Throwable)channelException);
                    }
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    try {
                        channel.sendResponse(TransportResponse.Empty.INSTANCE);
                    }
                    catch (Exception channelException) {
                        logger.warn(() -> new ParameterizedMessage("{} failed to send response while failing shard [{}]", (Object)request2.shardId, (Object)request), (Throwable)channelException);
                    }
                }
            });
        }
    }

    public static class ShardFailedClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<FailedShardEntry> {
        private final AllocationService allocationService;
        private final RerouteService rerouteService;
        private final Logger logger;
        private final Supplier<Priority> prioritySupplier;

        public ShardFailedClusterStateTaskExecutor(AllocationService allocationService, RerouteService rerouteService, Supplier<Priority> prioritySupplier, Logger logger) {
            this.allocationService = allocationService;
            this.rerouteService = rerouteService;
            this.logger = logger;
            this.prioritySupplier = prioritySupplier;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<FailedShardEntry> execute(ClusterState currentState, List<FailedShardEntry> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<FailedShardEntry> batchResultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ArrayList<FailedShardEntry> tasksToBeApplied = new ArrayList<FailedShardEntry>();
            ArrayList<FailedShard> failedShardsToBeApplied = new ArrayList<FailedShard>();
            ArrayList<StaleShard> staleShardsToBeApplied = new ArrayList<StaleShard>();
            for (FailedShardEntry task : tasks) {
                long currentPrimaryTerm;
                IndexMetadata indexMetadata = currentState.metadata().index(task.shardId.getIndex());
                if (indexMetadata == null) {
                    this.logger.debug("{} ignoring shard failed task [{}] (unknown index {})", (Object)task.shardId, (Object)task, (Object)task.shardId.getIndex());
                    batchResultBuilder.success(task);
                    continue;
                }
                if (task.primaryTerm > 0L && (currentPrimaryTerm = indexMetadata.primaryTerm(task.shardId.id())) != task.primaryTerm) {
                    assert (currentPrimaryTerm > task.primaryTerm) : "received a primary term with a higher term than in the current cluster state (received [" + task.primaryTerm + "] but current is [" + currentPrimaryTerm + "])";
                    this.logger.debug("{} failing shard failed task [{}] (primary term {} does not match current term {})", (Object)task.shardId, (Object)task, (Object)task.primaryTerm, (Object)indexMetadata.primaryTerm(task.shardId.id()));
                    batchResultBuilder.failure(task, new NoLongerPrimaryShardException(task.shardId, "primary term [" + task.primaryTerm + "] did not match current primary term [" + currentPrimaryTerm + "]"));
                    continue;
                }
                ShardRouting matched = currentState.getRoutingTable().getByAllocationId(task.shardId, task.allocationId);
                if (matched == null) {
                    Set<String> inSyncAllocationIds = indexMetadata.inSyncAllocationIds(task.shardId.id());
                    if (task.primaryTerm > 0L && inSyncAllocationIds.contains(task.allocationId)) {
                        this.logger.debug("{} marking shard {} as stale (shard failed task: [{}])", (Object)task.shardId, (Object)task.allocationId, (Object)task);
                        tasksToBeApplied.add(task);
                        staleShardsToBeApplied.add(new StaleShard(task.shardId, task.allocationId));
                        continue;
                    }
                    this.logger.debug("{} ignoring shard failed task [{}] (shard does not exist anymore)", (Object)task.shardId, (Object)task);
                    batchResultBuilder.success(task);
                    continue;
                }
                this.logger.debug("{} failing shard {} (shard failed task: [{}])", (Object)task.shardId, (Object)matched, (Object)task);
                tasksToBeApplied.add(task);
                failedShardsToBeApplied.add(new FailedShard(matched, task.message, task.failure, task.markAsStale));
            }
            assert (tasksToBeApplied.size() == failedShardsToBeApplied.size() + staleShardsToBeApplied.size());
            ClusterState maybeUpdatedState = currentState;
            try {
                maybeUpdatedState = this.applyFailedShards(currentState, failedShardsToBeApplied, staleShardsToBeApplied);
                batchResultBuilder.successes(tasksToBeApplied);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("failed to apply failed shards {}", (Object)failedShardsToBeApplied), (Throwable)e);
                batchResultBuilder.failures(tasksToBeApplied, e);
            }
            return batchResultBuilder.build(maybeUpdatedState);
        }

        ClusterState applyFailedShards(ClusterState currentState, List<FailedShard> failedShards, List<StaleShard> staleShards) {
            return this.allocationService.applyFailedShards(currentState, failedShards, staleShards);
        }

        @Override
        public void clusterStatePublished(ClusterChangedEvent clusterChangedEvent) {
            int numberOfUnassignedShards = clusterChangedEvent.state().getRoutingNodes().unassigned().size();
            if (numberOfUnassignedShards > 0) {
                String reason = String.format(Locale.ROOT, "[%d] unassigned shards after failing shards", numberOfUnassignedShards);
                this.logger.trace("{}, scheduling a reroute", (Object)reason);
                this.rerouteService.reroute(reason, this.prioritySupplier.get(), ActionListener.wrap(r -> this.logger.trace("{}, reroute completed", (Object)reason), e -> this.logger.debug((Message)new ParameterizedMessage("{}, reroute failed", (Object)reason), (Throwable)e)));
            }
        }
    }

    public static class FailedShardEntry
    extends TransportRequest {
        final ShardId shardId;
        final String allocationId;
        final long primaryTerm;
        final String message;
        @Nullable
        final Exception failure;
        final boolean markAsStale;

        FailedShardEntry(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.allocationId = in.readString();
            this.primaryTerm = in.readVLong();
            this.message = in.readString();
            this.failure = in.readException();
            this.markAsStale = in.readBoolean();
        }

        public FailedShardEntry(ShardId shardId, String allocationId, long primaryTerm, String message, @Nullable Exception failure, boolean markAsStale) {
            this.shardId = shardId;
            this.allocationId = allocationId;
            this.primaryTerm = primaryTerm;
            this.message = message;
            this.failure = failure;
            this.markAsStale = markAsStale;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.allocationId);
            out.writeVLong(this.primaryTerm);
            out.writeString(this.message);
            out.writeException(this.failure);
            out.writeBoolean(this.markAsStale);
        }

        public String toString() {
            ArrayList<CallSite> components = new ArrayList<CallSite>(6);
            components.add((CallSite)((Object)("shard id [" + this.shardId + "]")));
            components.add((CallSite)((Object)("allocation id [" + this.allocationId + "]")));
            components.add((CallSite)((Object)("primary term [" + this.primaryTerm + "]")));
            components.add((CallSite)((Object)("message [" + this.message + "]")));
            if (this.failure != null) {
                components.add((CallSite)((Object)("failure [" + ExceptionsHelper.detailedMessage(this.failure) + "]")));
            }
            components.add((CallSite)((Object)("markAsStale [" + this.markAsStale + "]")));
            return String.join((CharSequence)", ", components);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedShardEntry that = (FailedShardEntry)o;
            return Objects.equals(this.shardId, that.shardId) && Objects.equals(this.allocationId, that.allocationId) && this.primaryTerm == that.primaryTerm && this.markAsStale == that.markAsStale;
        }

        public int hashCode() {
            return Objects.hash(this.shardId, this.allocationId, this.primaryTerm, this.markAsStale);
        }
    }

    public static class StartedShardEntry
    extends TransportRequest {
        final ShardId shardId;
        final String allocationId;
        final long primaryTerm;
        final String message;

        StartedShardEntry(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.allocationId = in.readString();
            this.primaryTerm = in.readVLong();
            this.message = in.readString();
        }

        public StartedShardEntry(ShardId shardId, String allocationId, long primaryTerm, String message) {
            this.shardId = shardId;
            this.allocationId = allocationId;
            this.primaryTerm = primaryTerm;
            this.message = message;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.allocationId);
            out.writeVLong(this.primaryTerm);
            out.writeString(this.message);
        }

        public String toString() {
            return String.format(Locale.ROOT, "StartedShardEntry{shardId [%s], allocationId [%s], primary term [%d], message [%s]}", this.shardId, this.allocationId, this.primaryTerm, this.message);
        }
    }

    public static class NoLongerPrimaryShardException
    extends OpenSearchException {
        public NoLongerPrimaryShardException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public NoLongerPrimaryShardException(StreamInput in) throws IOException {
            super(in);
        }
    }
}

