/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedConsumer;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.compress.Compressor;
import org.graylog.shaded.opensearch2.org.opensearch.common.compress.CompressorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.BytesStreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.InputStreamStreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.OutputStreamStreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.transport.BytesTransportRequest;

public final class CompressedStreamUtils {
    private static final Logger logger = LogManager.getLogger(CompressedStreamUtils.class);

    public static BytesReference createCompressedStream(Version version, CheckedConsumer<StreamOutput, IOException> outputConsumer) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (OutputStreamStreamOutput stream = new OutputStreamStreamOutput(CompressorFactory.defaultCompressor().threadLocalOutputStream(bStream));){
            stream.setVersion(version);
            outputConsumer.accept(stream);
        }
        BytesReference serializedByteRef = bStream.bytes();
        logger.trace("serialized writable object for node version [{}] with size [{}]", (Object)version, (Object)serializedByteRef.length());
        return serializedByteRef;
    }

    public static StreamInput decompressBytes(BytesTransportRequest request, NamedWriteableRegistry namedWriteableRegistry) throws IOException {
        Compressor compressor = CompressorFactory.compressor(request.bytes());
        StreamInput in = compressor != null ? new InputStreamStreamInput(compressor.threadLocalInputStream(request.bytes().streamInput())) : request.bytes().streamInput();
        in.setVersion(request.version());
        return new NamedWriteableAwareStreamInput(in, namedWriteableRegistry);
    }
}

