/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationState;

public class InMemoryPersistedState
implements CoordinationState.PersistedState {
    private long currentTerm;
    private ClusterState acceptedState;

    public InMemoryPersistedState(long term, ClusterState acceptedState) {
        this.currentTerm = term;
        this.acceptedState = acceptedState;
        assert (this.currentTerm >= 0L);
        assert (this.getLastAcceptedState().term() <= this.currentTerm) : "last accepted term " + this.getLastAcceptedState().term() + " cannot be above current term " + this.currentTerm;
    }

    @Override
    public void setCurrentTerm(long currentTerm) {
        assert (this.currentTerm <= currentTerm);
        this.currentTerm = currentTerm;
    }

    @Override
    public void setLastAcceptedState(ClusterState clusterState) {
        this.acceptedState = clusterState;
    }

    @Override
    public long getCurrentTerm() {
        return this.currentTerm;
    }

    @Override
    public ClusterState getLastAcceptedState() {
        return this.acceptedState;
    }
}

