/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.joptsimple.OptionParser;
import org.graylog.shaded.opensearch2.joptsimple.OptionSet;
import org.graylog.shaded.opensearch2.joptsimple.OptionSpec;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.LockObtainFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover.Condition;
import org.graylog.shaded.opensearch2.org.opensearch.cli.EnvironmentAwareCommand;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.cli.UserException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterModule;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diff;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeEnvironment;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.PersistedClusterStateService;

public abstract class OpenSearchNodeCommand
extends EnvironmentAwareCommand {
    private static final Logger logger = LogManager.getLogger(OpenSearchNodeCommand.class);
    protected static final String DELIMITER = "------------------------------------------------------------------------\n";
    static final String STOP_WARNING_MSG = "------------------------------------------------------------------------\n\n    WARNING: OpenSearch MUST be stopped before running this tool.\n";
    protected static final String FAILED_TO_OBTAIN_NODE_LOCK_MSG = "failed to lock node's directory, is OpenSearch still running?";
    protected static final String ABORTED_BY_USER_MSG = "aborted by user";
    final OptionSpec<Integer> nodeOrdinalOption;
    static final String NO_NODE_FOLDER_FOUND_MSG = "no node folder is found in data folder(s), node has not been started yet?";
    static final String NO_NODE_METADATA_FOUND_MSG = "no node meta data is found, node has not been started yet?";
    protected static final String CS_MISSING_MSG = "cluster state is empty, cluster has never been bootstrapped?";
    public static final NamedXContentRegistry namedXContentRegistry = new NamedXContentRegistry((List)ClusterModule.getNamedXWriteables()){

        @Override
        public <T, C> T parseNamedObject(Class<T> categoryClass, String name, XContentParser parser, C context) throws IOException {
            if (Metadata.Custom.class.isAssignableFrom(categoryClass)) {
                if ("data_stream".equals(name)) {
                    return super.parseNamedObject(categoryClass, name, parser, context);
                }
                return (T)new UnknownMetadataCustom(name, parser.mapOrdered());
            }
            if (Condition.class.isAssignableFrom(categoryClass)) {
                assert (parser.currentToken() == XContentParser.Token.FIELD_NAME) : parser.currentToken();
                if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                    throw new UnsupportedOperationException("Unexpected token for Condition: " + parser.currentToken());
                }
                parser.nextToken();
                assert (parser.currentToken().isValue()) : parser.currentToken();
                if (!parser.currentToken().isValue()) {
                    throw new UnsupportedOperationException("Unexpected token for Condition: " + parser.currentToken());
                }
                return (T)new UnknownCondition(name, parser.objectText());
            }
            assert (false) : "Unexpected category class " + categoryClass + " for name " + name;
            throw new UnsupportedOperationException("Unexpected category class " + categoryClass + " for name " + name);
        }
    };

    public OpenSearchNodeCommand(String description) {
        super(description);
        this.nodeOrdinalOption = this.parser.accepts("ordinal", "Optional node ordinal, 0 if not specified").withRequiredArg().ofType(Integer.class);
    }

    public static PersistedClusterStateService createPersistedClusterStateService(Settings settings, Path[] dataPaths) throws IOException {
        NodeMetadata nodeMetadata = PersistedClusterStateService.nodeMetadata(dataPaths);
        if (nodeMetadata == null) {
            throw new OpenSearchException(NO_NODE_METADATA_FOUND_MSG, new Object[0]);
        }
        String nodeId = nodeMetadata.nodeId();
        return new PersistedClusterStateService(dataPaths, nodeId, namedXContentRegistry, BigArrays.NON_RECYCLING_INSTANCE, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), () -> 0L);
    }

    public static ClusterState clusterState(Environment environment, PersistedClusterStateService.OnDiskState onDiskState) {
        return ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(environment.settings())).version(onDiskState.lastAcceptedVersion).metadata(onDiskState.metadata).build();
    }

    public static Tuple<Long, ClusterState> loadTermAndClusterState(PersistedClusterStateService psf, Environment env) throws IOException {
        PersistedClusterStateService.OnDiskState bestOnDiskState = psf.loadBestOnDiskState();
        if (bestOnDiskState.empty()) {
            throw new OpenSearchException(CS_MISSING_MSG, new Object[0]);
        }
        return Tuple.tuple(bestOnDiskState.currentTerm, OpenSearchNodeCommand.clusterState(env, bestOnDiskState));
    }

    protected void processNodePaths(Terminal terminal, OptionSet options, Environment env) throws IOException, UserException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Obtaining lock for node");
        Integer nodeOrdinal = this.nodeOrdinalOption.value(options);
        if (nodeOrdinal == null) {
            nodeOrdinal = 0;
        }
        try (NodeEnvironment.NodeLock lock = new NodeEnvironment.NodeLock(nodeOrdinal, logger, env, x$0 -> Files.exists(x$0, new LinkOption[0]));){
            Path[] dataPaths = (Path[])Arrays.stream(lock.getNodePaths()).filter(Objects::nonNull).map(p -> p.path).toArray(Path[]::new);
            if (dataPaths.length == 0) {
                throw new OpenSearchException(NO_NODE_FOLDER_FOUND_MSG, new Object[0]);
            }
            this.processNodePaths(terminal, dataPaths, nodeOrdinal, options, env);
        }
        catch (LockObtainFailedException e) {
            throw new OpenSearchException(FAILED_TO_OBTAIN_NODE_LOCK_MSG, (Throwable)e, new Object[0]);
        }
    }

    protected void confirm(Terminal terminal, String msg) {
        terminal.println(msg);
        String text = terminal.readText("Confirm [y/N] ");
        if (!text.equalsIgnoreCase("y")) {
            throw new OpenSearchException(ABORTED_BY_USER_MSG, new Object[0]);
        }
    }

    @Override
    public final void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        terminal.println(STOP_WARNING_MSG);
        if (this.validateBeforeLock(terminal, env)) {
            this.processNodePaths(terminal, options, env);
        }
    }

    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        return true;
    }

    protected abstract void processNodePaths(Terminal var1, Path[] var2, int var3, OptionSet var4, Environment var5) throws IOException, UserException;

    protected NodeEnvironment.NodePath[] toNodePaths(Path[] dataPaths) {
        return (NodeEnvironment.NodePath[])Arrays.stream(dataPaths).map(OpenSearchNodeCommand::createNodePath).toArray(NodeEnvironment.NodePath[]::new);
    }

    private static NodeEnvironment.NodePath createNodePath(Path path) {
        try {
            return new NodeEnvironment.NodePath(path);
        }
        catch (IOException e) {
            throw new OpenSearchException("Unable to investigate path [" + path + "]", (Throwable)e, new Object[0]);
        }
    }

    OptionParser getParser() {
        return this.parser;
    }

    public static class UnknownCondition
    extends Condition<Object> {
        public UnknownCondition(String name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        public String getWriteableName() {
            return this.name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(this.name, this.value);
        }

        @Override
        public Condition.Result evaluate(Condition.Stats stats) {
            assert (false);
            throw new UnsupportedOperationException();
        }
    }

    public static class UnknownMetadataCustom
    implements Metadata.Custom {
        private final String name;
        private final Map<String, Object> contents;

        public UnknownMetadataCustom(String name, Map<String, Object> contents) {
            this.name = name;
            this.contents = contents;
        }

        @Override
        public EnumSet<Metadata.XContentContext> context() {
            return EnumSet.of(Metadata.XContentContext.API, Metadata.XContentContext.GATEWAY);
        }

        @Override
        public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWriteableName() {
            return this.name;
        }

        @Override
        public Version getMinimalSupportedVersion() {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (false);
            throw new UnsupportedOperationException();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.mapContents(this.contents);
        }
    }
}

