/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;

public class PublishResponse
implements Writeable {
    private final long term;
    private final long version;

    public PublishResponse(long term, long version) {
        assert (term >= 0L);
        assert (version >= 0L);
        this.term = term;
        this.version = version;
    }

    public PublishResponse(StreamInput in) throws IOException {
        this(in.readLong(), in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.term);
        out.writeLong(this.version);
    }

    public long getTerm() {
        return this.term;
    }

    public long getVersion() {
        return this.version;
    }

    public String toString() {
        return "PublishResponse{term=" + this.term + ", version=" + this.version + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishResponse response = (PublishResponse)o;
        if (this.term != response.term) {
            return false;
        }
        return this.version == response.version;
    }

    public int hashCode() {
        int result = (int)(this.term ^ this.term >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }
}

