/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

abstract class TermVersionRequest
extends TransportRequest
implements Writeable {
    protected final DiscoveryNode sourceNode;
    protected final long term;
    protected final long version;

    TermVersionRequest(DiscoveryNode sourceNode, long term, long version) {
        assert (term >= 0L);
        assert (version >= 0L);
        this.sourceNode = sourceNode;
        this.term = term;
        this.version = version;
    }

    TermVersionRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.term = in.readLong();
        this.version = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        out.writeLong(this.term);
        out.writeLong(this.version);
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public long getTerm() {
        return this.term;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermVersionRequest versionTerm = (TermVersionRequest)o;
        if (this.term != versionTerm.term) {
            return false;
        }
        if (this.version != versionTerm.version) {
            return false;
        }
        return this.sourceNode.equals(versionTerm.sourceNode);
    }

    public int hashCode() {
        int result = (int)(this.term ^ this.term >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + this.sourceNode.hashCode();
        return result;
    }

    public String toString() {
        return "TermVersionRequest{term=" + this.term + ", version=" + this.version + ", sourceNode=" + this.sourceNode + "}";
    }
}

