/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.decommission;

public enum DecommissionStatus {
    INIT("init"),
    DRAINING("draining"),
    IN_PROGRESS("in_progress"),
    SUCCESSFUL("successful"),
    FAILED("failed");

    private final String status;

    private DecommissionStatus(String status) {
        this.status = status;
    }

    public String status() {
        return this.status;
    }

    public static DecommissionStatus fromString(String status) {
        if (status == null) {
            throw new IllegalArgumentException("decommission status cannot be null");
        }
        if (status.equals(INIT.status())) {
            return INIT;
        }
        if (status.equals(DRAINING.status())) {
            return DRAINING;
        }
        if (status.equals(IN_PROGRESS.status())) {
            return IN_PROGRESS;
        }
        if (status.equals(SUCCESSFUL.status())) {
            return SUCCESSFUL;
        }
        if (status.equals(FAILED.status())) {
            return FAILED;
        }
        throw new IllegalStateException("Decommission status [" + status + "] not recognized.");
    }
}

