/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.AckedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasValidator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexAbstraction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataDeleteIndexService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.cluster.IndicesClusterStateService;

public class MetadataIndexAliasesService {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AliasValidator aliasValidator;
    private final MetadataDeleteIndexService deleteIndexService;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterManagerTaskThrottler.ThrottlingKey indexAliasTaskKey;

    @Inject
    public MetadataIndexAliasesService(ClusterService clusterService, IndicesService indicesService, AliasValidator aliasValidator, MetadataDeleteIndexService deleteIndexService, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasValidator = aliasValidator;
        this.deleteIndexService = deleteIndexService;
        this.xContentRegistry = xContentRegistry;
        this.indexAliasTaskKey = clusterService.registerClusterManagerTask("index-aliases", true);
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return MetadataIndexAliasesService.this.indexAliasTaskKey;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetadataIndexAliasesService.this.applyAliasActions(currentState, request.actions());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState applyAliasActions(ClusterState currentState, Iterable<AliasAction> actions) {
        ArrayList indicesToClose = new ArrayList();
        HashMap indices = new HashMap();
        try {
            ClusterState updatedState;
            boolean changed = false;
            HashSet<Index> indicesToDelete = new HashSet<Index>();
            for (AliasAction action : actions) {
                if (!action.removeIndex()) continue;
                IndexMetadata index = currentState.metadata().getIndices().get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                indicesToDelete.add(index.getIndex());
                changed = true;
            }
            if (changed) {
                currentState = this.deleteIndexService.deleteIndices(currentState, indicesToDelete);
            }
            Metadata.Builder metadata = Metadata.builder(currentState.metadata());
            HashSet<String> maybeModifiedIndices = new HashSet<String>();
            for (AliasAction action : actions) {
                if (action.removeIndex()) continue;
                Writeable index = metadata.get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                AliasAction.NewAliasValidator newAliasValidator = (arg_0, arg_1, arg_2, arg_3) -> this.lambda$applyAliasActions$2(metadata, action, indices, (IndexMetadata)index, indicesToClose, arg_0, arg_1, arg_2, arg_3);
                if (!action.apply(newAliasValidator, metadata, (IndexMetadata)index)) continue;
                changed = true;
                maybeModifiedIndices.add(((IndexMetadata)index).getIndex().getName());
            }
            for (String maybeModifiedIndex : maybeModifiedIndices) {
                IndexMetadata currentIndexMetadata = currentState.metadata().index(maybeModifiedIndex);
                IndexMetadata newIndexMetadata = metadata.get(maybeModifiedIndex);
                if (currentIndexMetadata.getAliases().equals(newIndexMetadata.getAliases())) continue;
                assert (currentIndexMetadata.getAliasesVersion() == newIndexMetadata.getAliasesVersion());
                metadata.put(new IndexMetadata.Builder(newIndexMetadata).aliasesVersion(1L + currentIndexMetadata.getAliasesVersion()));
            }
            if (changed && !(updatedState = ClusterState.builder(currentState).metadata(metadata).build()).metadata().equalsAliases(currentState.metadata())) {
                ClusterState clusterState = updatedState;
                return clusterState;
            }
            ClusterState clusterState = currentState;
            return clusterState;
        }
        finally {
            for (Index index : indicesToClose) {
                this.indicesService.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for alias processing");
            }
        }
    }

    private void validateAliasTargetIsNotDSBackingIndex(ClusterState currentState, AliasAction action) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(action.getIndex());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + action.getIndex() + "] was not found";
        if (indexAbstraction.getParentDataStream() != null) {
            throw new IllegalArgumentException("The provided index [ " + action.getIndex() + "] is a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data streams and their backing indices don't support alias operations.");
        }
    }

    private /* synthetic */ void lambda$applyAliasActions$2(Metadata.Builder metadata, AliasAction action, Map indices, IndexMetadata index, List indicesToClose, String alias, String indexRouting, String filter, Boolean writeIndex) {
        Function<String, IndexMetadata> indexLookup = name -> metadata.get((String)name);
        this.aliasValidator.validateAlias(alias, action.getIndex(), indexRouting, indexLookup);
        if (Strings.hasLength(filter)) {
            IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = (IndexService)indices.get(index.getIndex().getName());
            if (indexService == null) {
                indexService = this.indicesService.indexService(index.getIndex());
                if (indexService == null) {
                    try {
                        indexService = this.indicesService.createIndex(index, Collections.emptyList(), false);
                        indicesToClose.add(index.getIndex());
                    }
                    catch (IOException e) {
                        throw new OpenSearchException("Failed to create temporary index for parsing the alias", (Throwable)e, new Object[0]);
                    }
                    ((IndexService)indexService).mapperService().merge(index, MapperService.MergeReason.MAPPING_RECOVERY);
                }
                indices.put(action.getIndex(), indexService);
            }
            this.aliasValidator.validateAliasFilter(alias, filter, ((IndexService)indexService).newQueryShardContext(0, null, () -> System.currentTimeMillis(), null), this.xContentRegistry);
        }
    }
}

