/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;

public class WeightedRouting
implements Writeable {
    private String attributeName;
    private Map<String, Double> weights;

    public WeightedRouting() {
        this.attributeName = "";
        this.weights = new HashMap<String, Double>(3);
    }

    public WeightedRouting(String attributeName, Map<String, Double> weights) {
        this.attributeName = attributeName;
        this.weights = weights;
    }

    public WeightedRouting(WeightedRouting weightedRouting) {
        this.attributeName = weightedRouting.attributeName();
        this.weights = weightedRouting.weights;
    }

    public WeightedRouting(StreamInput in) throws IOException {
        this.attributeName = in.readString();
        this.weights = (Map)in.readGenericValue();
    }

    public boolean isSet() {
        return this.attributeName != null && !this.attributeName.isEmpty() && this.weights != null && !this.weights.isEmpty();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.attributeName);
        out.writeGenericValue(this.weights);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedRouting that = (WeightedRouting)o;
        if (!this.attributeName.equals(that.attributeName)) {
            return false;
        }
        return this.weights.equals(that.weights);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.weights);
    }

    public String toString() {
        return "WeightedRouting{" + this.attributeName + "}{" + this.weights().toString() + "}";
    }

    public Map<String, Double> weights() {
        return this.weights;
    }

    public String attributeName() {
        return this.attributeName;
    }
}

