/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.ObjectIntHashMap;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.graylog.shaded.opensearch2.org.opensearch.ResourceNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.delete.ClusterDeleteWeightedRoutingRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.delete.ClusterDeleteWeightedRoutingResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.decommission.DecommissionAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.decommission.DecommissionAttributeMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.decommission.DecommissionStatus;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.WeightedRoutingMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.UnsupportedWeightedRoutingStateException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.WeightedRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class WeightedRoutingService {
    private static final Logger logger = LogManager.getLogger(WeightedRoutingService.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;
    private static final Double DECOMMISSIONED_AWARENESS_VALUE_WEIGHT = 0.0;

    @Inject
    public WeightedRoutingService(ClusterService clusterService, ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.awarenessAttributes = AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(AwarenessAllocationDecider.CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
    }

    public void registerWeightedRoutingMetadata(final ClusterPutWeightedRoutingRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        final WeightedRouting newWeightedRouting = new WeightedRouting(request.getWeightedRouting());
        final long requestVersion = request.getVersion();
        this.clusterService.submitStateUpdateTask("update_weighted_routing", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public ClusterState execute(ClusterState currentState) {
                WeightedRoutingService.this.ensureWeightsSetForAllDiscoveredAndForcedAwarenessValues(currentState, request);
                WeightedRoutingService.this.ensureDecommissionedAttributeHasZeroWeight(currentState, request);
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                WeightedRoutingMetadata weightedRoutingMetadata = (WeightedRoutingMetadata)metadata.custom("weighted_shard_routing");
                WeightedRoutingService.this.ensureNoVersionConflict(requestVersion, weightedRoutingMetadata);
                if (weightedRoutingMetadata == null) {
                    logger.info("add weighted routing weights in metadata [{}]", (Object)newWeightedRouting);
                    weightedRoutingMetadata = new WeightedRoutingMetadata(newWeightedRouting, requestVersion + 1L);
                } else if (!newWeightedRouting.equals(weightedRoutingMetadata.getWeightedRouting())) {
                    logger.info("updated weighted routing weights [{}] in metadata", (Object)newWeightedRouting);
                    weightedRoutingMetadata = new WeightedRoutingMetadata(newWeightedRouting, requestVersion + 1L);
                } else {
                    logger.info("weights are same, not updating weighted routing weights [{}] in metadata", (Object)newWeightedRouting);
                    return currentState;
                }
                mdBuilder.putCustom("weighted_shard_routing", weightedRoutingMetadata);
                logger.info("building cluster state with weighted routing weights [{}]", (Object)newWeightedRouting);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to update cluster state for weighted routing weights [{}]", (Object)e));
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.debug("cluster weighted routing weights metadata change is processed by all the nodes");
                listener.onResponse(new ClusterStateUpdateResponse(true));
            }
        });
    }

    public void deleteWeightedRoutingMetadata(ClusterDeleteWeightedRoutingRequest request, final ActionListener<ClusterDeleteWeightedRoutingResponse> listener) {
        final long requestVersion = request.getVersion();
        final String awarenessAttribute = request.getAwarenessAttribute();
        this.clusterService.submitStateUpdateTask("delete_weighted_routing", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public ClusterState execute(ClusterState currentState) {
                logger.info("Deleting weighted routing metadata from the cluster state");
                Metadata metadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
                WeightedRoutingMetadata weightedRoutingMetadata = (WeightedRoutingMetadata)metadata.custom("weighted_shard_routing");
                WeightedRoutingService.this.ensureNoVersionConflict(requestVersion, weightedRoutingMetadata);
                if (!(weightedRoutingMetadata != null && awarenessAttribute == null || weightedRoutingMetadata != null && weightedRoutingMetadata.getWeightedRouting().attributeName().equals(awarenessAttribute))) {
                    throw new ResourceNotFoundException(String.format(Locale.ROOT, "weighted routing metadata does not have weights set for awareness attribute %s", awarenessAttribute), new Object[0]);
                }
                weightedRoutingMetadata = new WeightedRoutingMetadata(new WeightedRouting(), weightedRoutingMetadata.getVersion() + 1L);
                mdBuilder.putCustom("weighted_shard_routing", weightedRoutingMetadata);
                logger.info("building cluster state with weighted routing weights deleted");
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.error("failed to remove weighted routing metadata from cluster state", (Throwable)e);
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                logger.debug("cluster weighted routing metadata change is processed by all the nodes");
                listener.onResponse(new ClusterDeleteWeightedRoutingResponse(true));
            }
        });
    }

    List<String> getAwarenessAttributes() {
        return this.awarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map<String, Settings> forceGroups = forceSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
            List<String> aValues = entry.getValue().getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put(entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    public void verifyAwarenessAttribute(String attributeName) {
        if (!this.getAwarenessAttributes().contains(attributeName)) {
            ActionRequestValidationException validationException = null;
            validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "invalid awareness attribute %s requested for weighted routing", attributeName), validationException);
            throw validationException;
        }
    }

    private void ensureWeightsSetForAllDiscoveredAndForcedAwarenessValues(ClusterState state, ClusterPutWeightedRoutingRequest request) {
        String attributeName = request.getWeightedRouting().attributeName();
        ObjectIntHashMap<String> nodesPerAttribute = state.getRoutingNodes().nodesPerAttributesCounts(attributeName);
        HashSet<String> discoveredAwarenessValues = new HashSet<String>();
        for (ObjectCursor stringObjectCursor : nodesPerAttribute.keys()) {
            if (stringObjectCursor.value == null) continue;
            discoveredAwarenessValues.add((String)stringObjectCursor.value);
        }
        HashSet<String> allAwarenessValues = this.forcedAwarenessAttributes.get(attributeName) == null ? new HashSet<String>() : new HashSet(this.forcedAwarenessAttributes.get(attributeName));
        allAwarenessValues.addAll(discoveredAwarenessValues);
        AtomicInteger countWithZeroWeight = new AtomicInteger();
        allAwarenessValues.forEach(awarenessValue -> {
            if (!request.getWeightedRouting().weights().containsKey(awarenessValue)) {
                throw new UnsupportedWeightedRoutingStateException("weight for [" + awarenessValue + "] is not set and it is part of forced awareness value or a routing node has this attribute.", new Object[0]);
            }
            if (request.getWeightedRouting().weights().get(awarenessValue) == 0.0) {
                countWithZeroWeight.addAndGet(1);
            }
        });
        if (countWithZeroWeight.get() > allAwarenessValues.size() / 2) {
            throw ValidateActions.addValidationError(String.format(Locale.ROOT, "There are too many discovered attribute values [%s] given zero weight [%d]. Maximum expected number of routing weights having zero weight is [%d]", request.getWeightedRouting().weights().toString(), countWithZeroWeight.get(), allAwarenessValues.size() / 2), null);
        }
    }

    private void ensureDecommissionedAttributeHasZeroWeight(ClusterState state, ClusterPutWeightedRoutingRequest request) {
        DecommissionAttributeMetadata decommissionAttributeMetadata = state.metadata().decommissionAttributeMetadata();
        if (decommissionAttributeMetadata == null || decommissionAttributeMetadata.status().equals((Object)DecommissionStatus.FAILED)) {
            return;
        }
        DecommissionAttribute decommissionAttribute = decommissionAttributeMetadata.decommissionAttribute();
        WeightedRouting weightedRouting = request.getWeightedRouting();
        if (!weightedRouting.attributeName().equals(decommissionAttribute.attributeName())) {
            throw new UnsupportedWeightedRoutingStateException("decommission action ongoing for attribute [{}], cannot update weight for [{}]", decommissionAttribute.attributeName(), weightedRouting.attributeName());
        }
        if (!weightedRouting.weights().containsKey(decommissionAttribute.attributeValue())) {
            throw new UnsupportedWeightedRoutingStateException("weight for [{}] is not specified. Please specify its weight to [{}] as it is under decommission action", decommissionAttribute.attributeValue(), DECOMMISSIONED_AWARENESS_VALUE_WEIGHT);
        }
        if (!Objects.equals(weightedRouting.weights().get(decommissionAttribute.attributeValue()), DECOMMISSIONED_AWARENESS_VALUE_WEIGHT)) {
            throw new UnsupportedWeightedRoutingStateException("weight for [{}] must be set to [{}] as it is under decommission action", decommissionAttribute.attributeValue(), DECOMMISSIONED_AWARENESS_VALUE_WEIGHT);
        }
    }

    private void ensureNoVersionConflict(long requestedVersion, WeightedRoutingMetadata weightedRoutingMetadata) {
        if (weightedRoutingMetadata == null && requestedVersion != -1L || weightedRoutingMetadata != null && requestedVersion != weightedRoutingMetadata.getVersion()) {
            throw new UnsupportedWeightedRoutingStateException(String.format(Locale.ROOT, "requested version is %s but cluster weighted routing metadata is at a different version %s ", requestedVersion, weightedRoutingMetadata != null ? weightedRoutingMetadata.getVersion() : -1L), new Object[0]);
        }
    }
}

