/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation;

import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.Constraint;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.ConstraintTypes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.ShardsBalancer;

public class AllocationConstraints {
    private Map<String, Constraint> constraints = new HashMap<String, Constraint>();

    public AllocationConstraints() {
        this.constraints.putIfAbsent("index.shard.count.constraint", new Constraint(ConstraintTypes.isIndexShardsPerNodeBreached()));
        this.constraints.putIfAbsent("index.primary.shard.balance.constraint", new Constraint(ConstraintTypes.isPerIndexPrimaryShardsPerNodeBreached()));
        this.constraints.putIfAbsent("cluster.primary.shard.balance.constraint", new Constraint(ConstraintTypes.isPrimaryShardsPerNodeBreached()));
    }

    public void updateAllocationConstraint(String constraint, boolean enable) {
        this.constraints.get(constraint).setEnable(enable);
    }

    public long weight(ShardsBalancer balancer, BalancedShardsAllocator.ModelNode node, String index) {
        Constraint.ConstraintParams params = new Constraint.ConstraintParams(balancer, node, index);
        return params.weight(this.constraints);
    }
}

