/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.GroupedActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.client.Client;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.DiskUsage;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RerouteService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.set.Sets;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;

public class DiskThresholdMonitor {
    private static final Logger logger = LogManager.getLogger(DiskThresholdMonitor.class);
    private final DiskThresholdSettings diskThresholdSettings;
    private final Client client;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final LongSupplier currentTimeMillisSupplier;
    private final RerouteService rerouteService;
    private final AtomicLong lastRunTimeMillis = new AtomicLong(Long.MIN_VALUE);
    private final AtomicBoolean checkInProgress = new AtomicBoolean();
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(logger.getName());
    private final Set<String> nodesOverLowThreshold = Sets.newConcurrentHashSet();
    private final Set<String> nodesOverHighThreshold = Sets.newConcurrentHashSet();
    private final Set<String> nodesOverHighThresholdAndRelocating = Sets.newConcurrentHashSet();

    public DiskThresholdMonitor(Settings settings, Supplier<ClusterState> clusterStateSupplier, ClusterSettings clusterSettings, Client client, LongSupplier currentTimeMillisSupplier, RerouteService rerouteService) {
        this.clusterStateSupplier = clusterStateSupplier;
        this.currentTimeMillisSupplier = currentTimeMillisSupplier;
        this.rerouteService = rerouteService;
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        this.client = client;
        if (!this.diskThresholdSettings.isAutoReleaseIndexEnabled()) {
            this.deprecationLogger.deprecate("opensearch.disk.auto_release_flood_stage_block".replace(".", "_"), "[{}] will be removed in version {}", "opensearch.disk.auto_release_flood_stage_block", LegacyESVersion.V_7_4_0.major + 1);
        }
    }

    private void checkFinished() {
        boolean checkFinished = this.checkInProgress.compareAndSet(true, false);
        assert (checkFinished);
        logger.trace("checkFinished");
    }

    public void onNewInfo(ClusterInfo info) {
        if (!this.checkInProgress.compareAndSet(false, true)) {
            logger.info("skipping monitor as a check is already in progress");
            return;
        }
        Map<String, DiskUsage> usages = info.getNodeLeastAvailableDiskUsages();
        if (usages == null) {
            logger.trace("skipping monitor as no disk usage information is available");
            this.checkFinished();
            return;
        }
        logger.trace("processing new cluster info");
        boolean reroute = false;
        String explanation = "";
        long currentTimeMillis = this.currentTimeMillisSupplier.getAsLong();
        Set<String> nodes = usages.keySet();
        DiskThresholdMonitor.cleanUpRemovedNodes(nodes, this.nodesOverLowThreshold);
        DiskThresholdMonitor.cleanUpRemovedNodes(nodes, this.nodesOverHighThreshold);
        DiskThresholdMonitor.cleanUpRemovedNodes(nodes, this.nodesOverHighThresholdAndRelocating);
        ClusterState state = this.clusterStateSupplier.get();
        HashSet<String> indicesToMarkReadOnly = new HashSet<String>();
        RoutingNodes routingNodes = state.getRoutingNodes();
        HashSet<String> indicesNotToAutoRelease = new HashSet<String>();
        this.markNodesMissingUsageIneligibleForRelease(routingNodes, usages, indicesNotToAutoRelease);
        ArrayList<DiskUsage> usagesOverHighThreshold = new ArrayList<DiskUsage>();
        for (Map.Entry<String, DiskUsage> entry : usages.entrySet()) {
            String indexName;
            String node = entry.getKey();
            DiskUsage usage = entry.getValue();
            RoutingNode routingNode = routingNodes.node(node);
            if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdFloodStage().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdFloodStage()) {
                this.nodesOverLowThreshold.add(node);
                this.nodesOverHighThreshold.add(node);
                this.nodesOverHighThresholdAndRelocating.remove(node);
                if (routingNode != null) {
                    for (ShardRouting routing : routingNode) {
                        indexName = routing.index().getName();
                        indicesToMarkReadOnly.add(indexName);
                        indicesNotToAutoRelease.add(indexName);
                    }
                }
                logger.warn("flood stage disk watermark [{}] exceeded on {}, all indices on this node will be marked read-only", (Object)this.diskThresholdSettings.describeFloodStageThreshold(), (Object)usage);
                continue;
            }
            if ((usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) && routingNode != null) {
                for (ShardRouting routing : routingNode) {
                    indexName = routing.index().getName();
                    indicesNotToAutoRelease.add(indexName);
                }
            }
            long reservedSpace = info.getReservedSpace(usage.getNodeId(), usage.getPath()).getTotal();
            DiskUsage usageWithReservedSpace = new DiskUsage(usage.getNodeId(), usage.getNodeName(), usage.getPath(), usage.getTotalBytes(), Math.max(0L, usage.getFreeBytes() - reservedSpace));
            if (usageWithReservedSpace.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usageWithReservedSpace.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
                this.nodesOverLowThreshold.add(node);
                this.nodesOverHighThreshold.add(node);
                if (this.lastRunTimeMillis.get() <= currentTimeMillis - this.diskThresholdSettings.getRerouteInterval().millis()) {
                    reroute = true;
                    explanation = "high disk watermark exceeded on one or more nodes";
                    usagesOverHighThreshold.add(usage);
                    continue;
                }
                logger.debug("high disk watermark exceeded on {} but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
                continue;
            }
            if (usageWithReservedSpace.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes() || usageWithReservedSpace.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdLow()) {
                this.nodesOverHighThresholdAndRelocating.remove(node);
                boolean wasUnderLowThreshold = this.nodesOverLowThreshold.add(node);
                boolean wasOverHighThreshold = this.nodesOverHighThreshold.remove(node);
                assert (!(wasUnderLowThreshold && wasOverHighThreshold));
                if (wasUnderLowThreshold) {
                    logger.info("low disk watermark [{}] exceeded on {}, replicas will not be assigned to this node", (Object)this.diskThresholdSettings.describeLowThreshold(), (Object)usage);
                    continue;
                }
                if (!wasOverHighThreshold) continue;
                logger.info("high disk watermark [{}] no longer exceeded on {}, but low disk watermark [{}] is still exceeded", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)usage, (Object)this.diskThresholdSettings.describeLowThreshold());
                continue;
            }
            this.nodesOverHighThresholdAndRelocating.remove(node);
            if (!this.nodesOverLowThreshold.contains(node)) continue;
            if (this.lastRunTimeMillis.get() <= currentTimeMillis - this.diskThresholdSettings.getRerouteInterval().millis()) {
                reroute = true;
                explanation = "one or more nodes has gone under the high or low watermark";
                this.nodesOverLowThreshold.remove(node);
                this.nodesOverHighThreshold.remove(node);
                logger.info("low disk watermark [{}] no longer exceeded on {}", (Object)this.diskThresholdSettings.describeLowThreshold(), (Object)usage);
                continue;
            }
            logger.debug("{} has gone below a disk threshold, but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
        }
        GroupedActionListener<Void> listener = new GroupedActionListener<Void>(ActionListener.wrap(this::checkFinished), 4);
        if (reroute) {
            logger.debug("rerouting shards: [{}]", (Object)explanation);
            this.rerouteService.reroute("disk threshold monitor", Priority.HIGH, ActionListener.wrap(reroutedClusterState -> {
                for (DiskUsage diskUsage : usagesOverHighThreshold) {
                    DiskUsage usageIncludingRelocations;
                    long relocatingShardsSize;
                    RoutingNode routingNode = reroutedClusterState.getRoutingNodes().node(diskUsage.getNodeId());
                    if (routingNode != null) {
                        relocatingShardsSize = this.sizeOfRelocatingShards(routingNode, diskUsage, info, (ClusterState)reroutedClusterState);
                        usageIncludingRelocations = new DiskUsage(diskUsage.getNodeId(), diskUsage.getNodeName(), diskUsage.getPath(), diskUsage.getTotalBytes(), diskUsage.getFreeBytes() - relocatingShardsSize);
                    } else {
                        usageIncludingRelocations = diskUsage;
                        relocatingShardsSize = 0L;
                    }
                    if (usageIncludingRelocations.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usageIncludingRelocations.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
                        this.nodesOverHighThresholdAndRelocating.remove(diskUsage.getNodeId());
                        logger.warn("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node; currently relocating away shards totalling [{}] bytes; the node is expected to continue to exceed the high disk watermark when these relocations are complete", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)diskUsage, (Object)(-relocatingShardsSize));
                        continue;
                    }
                    if (this.nodesOverHighThresholdAndRelocating.add(diskUsage.getNodeId())) {
                        logger.info("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node; currently relocating away shards totalling [{}] bytes; the node is expected to be below the high disk watermark when these relocations are complete", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)diskUsage, (Object)(-relocatingShardsSize));
                        continue;
                    }
                    logger.debug("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node; currently relocating away shards totalling [{}] bytes", (Object)this.diskThresholdSettings.describeHighThreshold(), (Object)diskUsage, (Object)(-relocatingShardsSize));
                }
                this.setLastRunTimeMillis();
                listener.onResponse(null);
            }, e -> {
                logger.debug("reroute failed", (Throwable)e);
                this.setLastRunTimeMillis();
                listener.onFailure((Exception)e);
            }));
        } else {
            logger.trace("no reroute required");
            listener.onResponse(null);
        }
        Set<String> indicesToAutoRelease = StreamSupport.stream(Spliterators.spliterator(state.routingTable().indicesRouting().entrySet(), 0), false).map(c -> (String)c.getKey()).filter(index -> !indicesNotToAutoRelease.contains(index)).filter(index -> state.getBlocks().hasIndexBlock((String)index, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK)).collect(Collectors.toSet());
        if (!indicesToAutoRelease.isEmpty()) {
            if (this.diskThresholdSettings.isAutoReleaseIndexEnabled()) {
                logger.info("releasing read-only-allow-delete block on indices: [{}]", indicesToAutoRelease);
                this.updateIndicesReadOnly(indicesToAutoRelease, listener, false);
            } else {
                this.deprecationLogger.deprecate("opensearch.disk.auto_release_flood_stage_block".replace(".", "_"), "[{}] will be removed in version {}", "opensearch.disk.auto_release_flood_stage_block", LegacyESVersion.V_7_4_0.major + 1);
                logger.debug("[{}] disabled, not releasing read-only-allow-delete block on indices: [{}]", (Object)"opensearch.disk.auto_release_flood_stage_block", indicesToAutoRelease);
                listener.onResponse(null);
            }
        } else {
            logger.trace("no auto-release required");
            listener.onResponse(null);
        }
        indicesToMarkReadOnly.removeIf(index -> state.getBlocks().indexBlocked(ClusterBlockLevel.WRITE, (String)index));
        logger.trace("marking indices as read-only: [{}]", indicesToMarkReadOnly);
        if (!indicesToMarkReadOnly.isEmpty()) {
            this.updateIndicesReadOnly(indicesToMarkReadOnly, listener, true);
        } else {
            listener.onResponse(null);
        }
        if (!state.getBlocks().hasGlobalBlockWithId(Metadata.CLUSTER_CREATE_INDEX_BLOCK.id()) && nodes.size() > 0 && this.nodesOverHighThreshold.size() == nodes.size()) {
            this.setIndexCreateBlock(listener, true);
        } else if (state.getBlocks().hasGlobalBlockWithId(Metadata.CLUSTER_CREATE_INDEX_BLOCK.id()) && this.diskThresholdSettings.isCreateIndexBlockAutoReleaseEnabled()) {
            this.setIndexCreateBlock(listener, false);
        } else {
            listener.onResponse(null);
        }
    }

    long sizeOfRelocatingShards(RoutingNode routingNode, DiskUsage diskUsage, ClusterInfo info, ClusterState reroutedClusterState) {
        return DiskThresholdDecider.sizeOfRelocatingShards(routingNode, true, diskUsage.getPath(), info, reroutedClusterState.metadata(), reroutedClusterState.routingTable());
    }

    private void markNodesMissingUsageIneligibleForRelease(RoutingNodes routingNodes, Map<String, DiskUsage> usages, Set<String> indicesToMarkIneligibleForAutoRelease) {
        for (RoutingNode routingNode : routingNodes) {
            if (usages.containsKey(routingNode.nodeId()) || routingNode == null) continue;
            for (ShardRouting routing : routingNode) {
                String indexName = routing.index().getName();
                indicesToMarkIneligibleForAutoRelease.add(indexName);
            }
        }
    }

    private void setLastRunTimeMillis() {
        this.lastRunTimeMillis.getAndUpdate(l -> Math.max(l, this.currentTimeMillisSupplier.getAsLong()));
    }

    protected void setIndexCreateBlock(ActionListener<Void> listener, boolean indexCreateBlock) {
        ActionListener<Void> wrappedListener = ActionListener.wrap(r -> {
            this.setLastRunTimeMillis();
            listener.onResponse((Void)r);
        }, e -> {
            logger.debug("setting index create block failed", (Throwable)e);
            this.setLastRunTimeMillis();
            listener.onFailure((Exception)e);
        });
        Settings indexCreateBlockSetting = indexCreateBlock ? Settings.builder().put(Metadata.SETTING_CREATE_INDEX_BLOCK_SETTING.getKey(), Boolean.TRUE.toString()).build() : Settings.builder().putNull(Metadata.SETTING_CREATE_INDEX_BLOCK_SETTING.getKey()).build();
        this.client.admin().cluster().prepareUpdateSettings().setPersistentSettings(indexCreateBlockSetting).execute(ActionListener.map(wrappedListener, r -> null));
    }

    protected void updateIndicesReadOnly(Set<String> indicesToUpdate, ActionListener<Void> listener, boolean readOnly) {
        ActionListener<Void> wrappedListener = ActionListener.wrap(r -> {
            this.setLastRunTimeMillis();
            listener.onResponse((Void)r);
        }, e -> {
            logger.debug((Message)new ParameterizedMessage("setting indices [{}] read-only failed", (Object)readOnly), (Throwable)e);
            this.setLastRunTimeMillis();
            listener.onFailure((Exception)e);
        });
        Settings readOnlySettings = readOnly ? Settings.builder().put(IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE, Boolean.TRUE.toString()).build() : Settings.builder().putNull(IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE).build();
        this.client.admin().indices().prepareUpdateSettings(indicesToUpdate.toArray(Strings.EMPTY_ARRAY)).setSettings(readOnlySettings).execute(ActionListener.map(wrappedListener, r -> null));
    }

    private static void cleanUpRemovedNodes(Set<String> nodesToKeep, Set<String> nodesToCleanUp) {
        for (String node : nodesToCleanUp) {
            if (nodesToKeep.contains(node)) continue;
            nodesToCleanUp.remove(node);
        }
    }
}

