/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RecoverySource;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.UnassignedInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RerouteExplanation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.command.AllocationCommand;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public abstract class AbstractAllocateAllocationCommand
implements AllocationCommand {
    private static final String INDEX_FIELD = "index";
    private static final String SHARD_FIELD = "shard";
    private static final String NODE_FIELD = "node";
    protected final String index;
    protected final int shardId;
    protected final String node;

    protected static <T extends Builder<?>> ObjectParser<T, Void> createAllocateParser(String command) {
        ObjectParser parser = new ObjectParser(command);
        parser.declareString(Builder::setIndex, new ParseField(INDEX_FIELD, new String[0]));
        parser.declareInt(Builder::setShard, new ParseField(SHARD_FIELD, new String[0]));
        parser.declareString(Builder::setNode, new ParseField(NODE_FIELD, new String[0]));
        return parser;
    }

    protected AbstractAllocateAllocationCommand(String index, int shardId, String node) {
        this.index = index;
        this.shardId = shardId;
        this.node = node;
    }

    protected AbstractAllocateAllocationCommand(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.node = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeString(this.node);
    }

    public String index() {
        return this.index;
    }

    public int shardId() {
        return this.shardId;
    }

    public String node() {
        return this.node;
    }

    protected RerouteExplanation explainOrThrowMissingRoutingNode(RoutingAllocation allocation, boolean explain, DiscoveryNode discoNode) {
        if (!discoNode.isDataNode()) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "allocation can only be done on data nodes, not [" + this.node + "]");
        }
        return this.explainOrThrowRejectedCommand(explain, allocation, "could not find [" + this.node + "] among the routing nodes");
    }

    protected RerouteExplanation explainOrThrowRejectedCommand(boolean explain, RoutingAllocation allocation, String reason) {
        if (explain) {
            return new RerouteExplanation(this, allocation.decision(Decision.NO, this.name() + " (allocation command)", reason, new Object[0]));
        }
        throw new IllegalArgumentException("[" + this.name() + "] " + reason);
    }

    protected RerouteExplanation explainOrThrowRejectedCommand(boolean explain, RoutingAllocation allocation, RuntimeException rte) {
        if (explain) {
            return new RerouteExplanation(this, allocation.decision(Decision.NO, this.name() + " (allocation command)", rte.getMessage(), new Object[0]));
        }
        throw rte;
    }

    protected void initializeUnassignedShard(RoutingAllocation allocation, RoutingNodes routingNodes, RoutingNode routingNode, ShardRouting shardRouting) {
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting, null, null);
    }

    protected void initializeUnassignedShard(RoutingAllocation allocation, RoutingNodes routingNodes, RoutingNode routingNode, ShardRouting shardRouting, @Nullable UnassignedInfo unassignedInfo, @Nullable RecoverySource recoverySource) {
        RoutingNodes.UnassignedShards.UnassignedIterator it = routingNodes.unassigned().iterator();
        while (it.hasNext()) {
            ShardRouting unassigned = it.next();
            if (!unassigned.equalsIgnoringMetadata(shardRouting)) continue;
            if (unassignedInfo != null || recoverySource != null) {
                unassigned = it.updateUnassigned(unassignedInfo != null ? unassignedInfo : unassigned.unassignedInfo(), recoverySource != null ? recoverySource : unassigned.recoverySource(), allocation.changes());
            }
            it.initialize(routingNode.nodeId(), null, allocation.clusterInfo().getShardSize(unassigned, -1L), allocation.changes());
            return;
        }
        assert (false) : "shard to initialize not found in list of unassigned shards";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_FIELD, this.index());
        builder.field(SHARD_FIELD, this.shardId());
        builder.field(NODE_FIELD, this.node());
        this.extraXContent(builder);
        return builder.endObject();
    }

    protected void extraXContent(XContentBuilder builder) throws IOException {
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAllocateAllocationCommand other = (AbstractAllocateAllocationCommand)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.shardId, other.shardId) && Objects.equals(this.node, other.node);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.shardId, this.node);
    }

    protected static abstract class Builder<T extends AbstractAllocateAllocationCommand> {
        protected String index;
        protected int shard = -1;
        protected String node;

        protected Builder() {
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public void setShard(int shard) {
            this.shard = shard;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public abstract Builder<T> parse(XContentParser var1) throws IOException;

        public abstract T build();

        protected void validate() {
            if (this.index == null) {
                throw new IllegalArgumentException("Argument [index] must be defined");
            }
            if (this.shard < 0) {
                throw new IllegalArgumentException("Argument [shard] must be defined and non-negative");
            }
            if (this.node == null) {
                throw new IllegalArgumentException("Argument [node] must be defined");
            }
        }
    }
}

