/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class Numbers {
    public static final BigInteger MAX_UNSIGNED_LONG_VALUE = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    public static final BigInteger MIN_UNSIGNED_LONG_VALUE = BigInteger.ZERO;
    public static final long MIN_UNSIGNED_LONG_VALUE_AS_LONG = MIN_UNSIGNED_LONG_VALUE.longValue();
    public static final long MAX_UNSIGNED_LONG_VALUE_AS_LONG = MAX_UNSIGNED_LONG_VALUE.longValue();
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigDecimal BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    private static BigDecimal BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);
    private static BigDecimal BIGDECIMAL_GREATER_THAN_USIGNED_LONG_MAX_VALUE = new BigDecimal(MAX_UNSIGNED_LONG_VALUE).add(BigDecimal.ONE);
    private static BigDecimal BIGDECIMAL_LESS_THAN_USIGNED_LONG_MIN_VALUE = new BigDecimal(MIN_UNSIGNED_LONG_VALUE).subtract(BigDecimal.ONE);

    private Numbers() {
    }

    public static byte[] longToBytes(long val) {
        byte[] arr = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return arr;
    }

    public static boolean isValidDouble(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static long toLongExact(Number n) {
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long) {
            return n.longValue();
        }
        if (n instanceof Float || n instanceof Double) {
            double d = n.doubleValue();
            if (d != (double)Math.round(d)) {
                throw new IllegalArgumentException(n + " is not an integer value");
            }
            return n.longValue();
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).toBigIntegerExact().longValueExact();
        }
        if (n instanceof BigInteger) {
            return ((BigInteger)n).longValueExact();
        }
        throw new IllegalArgumentException("Cannot check whether [" + n + "] of class [" + n.getClass().getName() + "] is actually a long");
    }

    public static BigInteger toBigIntegerExact(Number n) {
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long) {
            return BigInteger.valueOf(n.longValue());
        }
        if (n instanceof Float || n instanceof Double) {
            double d = n.doubleValue();
            if (d != (double)Math.round(d)) {
                throw new IllegalArgumentException(n + " is not an integer value");
            }
            return BigInteger.valueOf(n.longValue());
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).toBigIntegerExact();
        }
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        throw new IllegalArgumentException("Cannot convert [" + n + "] of class [" + n.getClass().getName() + "] to a BigInteger");
    }

    public static BigInteger toUnsignedLongExact(Number value) {
        BigInteger v = Numbers.toBigIntegerExact(value);
        if (v.compareTo(MAX_UNSIGNED_LONG_VALUE) > 0 || v.compareTo(MIN_UNSIGNED_LONG_VALUE) < 0) {
            throw new IllegalArgumentException("Value [" + value + "] is out of range for an unsigned long");
        }
        return v;
    }

    public static long toLong(String stringValue, boolean coerce) {
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            BigInteger bigIntegerValue;
            try {
                BigDecimal bigDecimalValue = new BigDecimal(stringValue);
                if (bigDecimalValue.compareTo(BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE) >= 0 || bigDecimalValue.compareTo(BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE) <= 0) {
                    throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
                }
                bigIntegerValue = coerce ? bigDecimalValue.toBigInteger() : bigDecimalValue.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Value [" + stringValue + "] has a decimal part");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("For input string: \"" + stringValue + "\"");
            }
            if (bigIntegerValue.compareTo(MAX_LONG_VALUE) > 0 || bigIntegerValue.compareTo(MIN_LONG_VALUE) < 0) {
                throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
            }
            return bigIntegerValue.longValue();
        }
    }

    public static BigInteger toUnsignedLong(String stringValue, boolean coerce) {
        BigInteger bigIntegerValue;
        try {
            BigDecimal bigDecimalValue = new BigDecimal(stringValue);
            if (bigDecimalValue.compareTo(BIGDECIMAL_GREATER_THAN_USIGNED_LONG_MAX_VALUE) >= 0 || bigDecimalValue.compareTo(BIGDECIMAL_LESS_THAN_USIGNED_LONG_MIN_VALUE) <= 0) {
                throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for an unsigned long");
            }
            bigIntegerValue = coerce ? bigDecimalValue.toBigInteger() : bigDecimalValue.toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Value [" + stringValue + "] has a decimal part");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("For input string: \"" + stringValue + "\"");
        }
        if (bigIntegerValue.compareTo(MAX_UNSIGNED_LONG_VALUE) > 0 || bigIntegerValue.compareTo(MIN_UNSIGNED_LONG_VALUE) < 0) {
            throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for an unsigned long");
        }
        return bigIntegerValue;
    }

    public static int toIntExact(Number n) {
        return Math.toIntExact(Numbers.toLongExact(n));
    }

    public static short toShortExact(Number n) {
        long l = Numbers.toLongExact(n);
        if (l != (long)((short)l)) {
            throw new ArithmeticException("short overflow: " + l);
        }
        return (short)l;
    }

    public static byte toByteExact(Number n) {
        long l = Numbers.toLongExact(n);
        if (l != (long)((byte)l)) {
            throw new ArithmeticException("byte overflow: " + l);
        }
        return (byte)l;
    }

    public static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static double unsignedLongToDouble(long value) {
        if (value >= 0L) {
            return value;
        }
        return (double)(value >>> 1 | value & 1L) * 2.0;
    }
}

