/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.jvm.JvmInfo;

public final class PidFile {
    private final long pid;
    private final Path path;
    private final boolean deleteOnExit;

    private PidFile(Path path, boolean deleteOnExit, long pid) throws IOException {
        this.path = path;
        this.deleteOnExit = deleteOnExit;
        this.pid = pid;
    }

    public static PidFile create(Path path, boolean deleteOnExit) throws IOException {
        return PidFile.create(path, deleteOnExit, JvmInfo.jvmInfo().pid());
    }

    static PidFile create(Path path, boolean deleteOnExit, long pid) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            if (Files.exists(parent, new LinkOption[0]) && !Files.isDirectory(parent, new LinkOption[0])) {
                throw new IllegalArgumentException(parent + " exists but is not a directory");
            }
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
        }
        if (Files.exists(path, new LinkOption[0]) && !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException(path + " exists but is not a regular file");
        }
        try (OutputStream stream = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            stream.write(Long.toString(pid).getBytes(StandardCharsets.UTF_8));
        }
        if (deleteOnExit) {
            PidFile.addShutdownHook(path);
        }
        return new PidFile(path, deleteOnExit, pid);
    }

    public long getPid() {
        return this.pid;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    private static void addShutdownHook(final Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    throw new OpenSearchException("Failed to delete pid file " + path, (Throwable)e, new Object[0]);
                }
            }
        });
    }
}

