/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.breaker;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.breaker.CircuitBreaker;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;

public class CircuitBreakingException
extends OpenSearchException {
    private final long bytesWanted;
    private final long byteLimit;
    private final CircuitBreaker.Durability durability;

    public CircuitBreakingException(StreamInput in) throws IOException {
        super(in);
        this.byteLimit = in.readLong();
        this.bytesWanted = in.readLong();
        this.durability = in.getVersion().onOrAfter(LegacyESVersion.V_7_0_0) ? in.readEnum(CircuitBreaker.Durability.class) : CircuitBreaker.Durability.PERMANENT;
    }

    public CircuitBreakingException(String message, CircuitBreaker.Durability durability) {
        this(message, 0L, 0L, durability);
    }

    public CircuitBreakingException(String message, long bytesWanted, long byteLimit, CircuitBreaker.Durability durability) {
        super(message, new Object[0]);
        this.bytesWanted = bytesWanted;
        this.byteLimit = byteLimit;
        this.durability = durability;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.byteLimit);
        out.writeLong(this.bytesWanted);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_0_0)) {
            out.writeEnum(this.durability);
        }
    }

    public long getBytesWanted() {
        return this.bytesWanted;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    public CircuitBreaker.Durability getDurability() {
        return this.durability;
    }

    @Override
    public RestStatus status() {
        return RestStatus.TOO_MANY_REQUESTS;
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("bytes_wanted", this.bytesWanted);
        builder.field("bytes_limit", this.byteLimit);
        builder.field("durability", (Object)this.durability);
    }
}

