/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.compress;

import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.compress.Compressor;

public class ZstdCompressor
implements Compressor {
    private static final byte[] HEADER = new byte[]{90, 83, 84, 68, 0};
    private static final int LEVEL = 3;
    private static final int BUFFER_SIZE = 4096;

    @Override
    public boolean isCompressed(BytesReference bytes) {
        if (bytes.length() < HEADER.length) {
            return false;
        }
        for (int i = 0; i < HEADER.length; ++i) {
            if (bytes.get(i) == HEADER[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int headerLength() {
        return HEADER.length;
    }

    @Override
    public InputStream threadLocalInputStream(InputStream in) throws IOException {
        byte[] header = in.readNBytes(HEADER.length);
        if (!Arrays.equals(header, HEADER)) {
            throw new IllegalArgumentException("Input stream is not compressed with ZSTD!");
        }
        return new ZstdInputStreamNoFinalizer(new BufferedInputStream(in, 4096), RecyclingBufferPool.INSTANCE);
    }

    @Override
    public OutputStream threadLocalOutputStream(OutputStream out) throws IOException {
        out.write(HEADER);
        return new ZstdOutputStreamNoFinalizer(new BufferedOutputStream(out, 4096), RecyclingBufferPool.INSTANCE, 3);
    }

    @Override
    public BytesReference uncompress(BytesReference bytesReference) throws IOException {
        throw new UnsupportedOperationException("ZSTD compression is supported only for snapshotting");
    }

    @Override
    public BytesReference compress(BytesReference bytesReference) throws IOException {
        throw new UnsupportedOperationException("ZSTD compression is supported only for snapshotting");
    }
}

