/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeType;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.parsers.ShapeParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.shape.Point;

public class PointBuilder
extends ShapeBuilder<Point, org.graylog.shaded.opensearch2.org.opensearch.geometry.Point, PointBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.POINT;

    public PointBuilder() {
        this.coordinates.add(ZERO_ZERO);
    }

    public PointBuilder(double lon, double lat) {
        this.coordinates.add(new Coordinate(lon, lat));
    }

    public PointBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public PointBuilder coordinate(Coordinate coordinate) {
        this.coordinates.set(0, coordinate);
        return this;
    }

    public double longitude() {
        return ((Coordinate)this.coordinates.get((int)0)).x;
    }

    public double latitude() {
        return ((Coordinate)this.coordinates.get((int)0)).y;
    }

    public static PointBuilder newPoint(double longitude, double latitude) {
        return new PointBuilder().coordinate(new Coordinate(longitude, latitude));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
        PointBuilder.toXContent(builder, (Coordinate)this.coordinates.get(0));
        return builder.endObject();
    }

    @Override
    public Point buildS4J() {
        return SPATIAL_CONTEXT.makePoint(((Coordinate)this.coordinates.get((int)0)).x, ((Coordinate)this.coordinates.get((int)0)).y);
    }

    @Override
    public org.graylog.shaded.opensearch2.org.opensearch.geometry.Point buildGeometry() {
        return new org.graylog.shaded.opensearch2.org.opensearch.geometry.Point(((Coordinate)this.coordinates.get((int)0)).x, ((Coordinate)this.coordinates.get((int)0)).y);
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public int numDimensions() {
        return Double.isNaN(((Coordinate)this.coordinates.get((int)0)).z) ? 2 : 3;
    }
}

