/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.io.stream;

import java.time.Instant;
import java.time.ZoneId;
import org.graylog.shaded.opensearch2.org.joda.time.DateTimeZone;
import org.graylog.shaded.opensearch2.org.joda.time.ReadableInstant;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPoint;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.DateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.script.JodaCompatibleZonedDateTime;

public final class Streamables {
    private Streamables() {
    }

    public static void registerStreamables() {
        Streamables.registerWriters();
        Streamables.registerReaders();
    }

    private static void registerWriters() {
        Writeable.WriteableRegistry.registerWriter(ReadableInstant.class, (o, v) -> {
            o.writeByte((byte)13);
            ReadableInstant instant = (ReadableInstant)v;
            o.writeString(instant.getZone().getID());
            o.writeLong(instant.getMillis());
        });
        Writeable.WriteableRegistry.registerClassAlias(ReadableInstant.class, ReadableInstant.class);
        Writeable.WriteableRegistry.registerWriter(JodaCompatibleZonedDateTime.class, (o, v) -> {
            o.writeByte((byte)13);
            JodaCompatibleZonedDateTime zonedDateTime = (JodaCompatibleZonedDateTime)v;
            String zoneId = zonedDateTime.getZonedDateTime().getZone().getId();
            o.writeString(zoneId.equals("Z") ? DateTimeZone.UTC.getID() : zoneId);
            o.writeLong(zonedDateTime.toInstant().toEpochMilli());
        });
        Writeable.WriteableRegistry.registerWriter(GeoPoint.class, (o, v) -> {
            o.writeByte((byte)22);
            ((GeoPoint)v).writeTo(o);
        });
    }

    private static void registerReaders() {
        Writeable.WriteableRegistry.registerReader((byte)13, i -> {
            ZoneId zoneId = DateUtils.dateTimeZoneToZoneId(DateTimeZone.forID(i.readString()));
            long millis = i.readLong();
            return new JodaCompatibleZonedDateTime(Instant.ofEpochMilli(millis), zoneId);
        });
        Writeable.WriteableRegistry.registerReader((byte)22, GeoPoint::new);
    }
}

