/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.CombineFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.Functions;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.LeafScoreFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.ScoreFunction;
import org.graylog.shaded.opensearch2.org.opensearch.script.ExplainableScoreScript;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScoreScript;
import org.graylog.shaded.opensearch2.org.opensearch.script.Script;

public class ScriptScoreFunction
extends ScoreFunction {
    private final Script sScript;
    private final ScoreScript.LeafFactory script;
    private final int shardId;
    private final String indexName;
    private final Version indexVersion;
    private final String functionName;

    public ScriptScoreFunction(Script sScript, ScoreScript.LeafFactory script, String indexName, int shardId, Version indexVersion, @Nullable String functionName) {
        super(CombineFunction.REPLACE);
        this.sScript = sScript;
        this.script = script;
        this.indexName = indexName;
        this.shardId = shardId;
        this.indexVersion = indexVersion;
        this.functionName = functionName;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final ScoreScript leafScript = this.script.newInstance(ctx);
        final CannedScorer scorer = new CannedScorer();
        leafScript.setScorer(scorer);
        leafScript._setIndexName(this.indexName);
        leafScript._setShard(this.shardId);
        leafScript._setIndexVersion(this.indexVersion);
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore;
                double result = leafScript.execute(null);
                if (result < 0.0) {
                    throw new IllegalArgumentException("script score function must not produce negative scores, but got: [" + result + "]");
                }
                return result;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                if (!(leafScript instanceof ExplainableScoreScript)) {
                    double score = this.score(docId, subQueryScore.getValue().floatValue());
                    String explanation = "script score function" + Functions.nameOrEmptyFunc(ScriptScoreFunction.this.functionName) + ", computed with script:\"" + ScriptScoreFunction.this.sScript + "\"";
                    Explanation scoreExp = Explanation.match(subQueryScore.getValue(), "_score: ", subQueryScore);
                    return Explanation.match((Number)Float.valueOf((float)score), explanation, scoreExp);
                }
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore.getValue().floatValue();
                Explanation exp = ((ExplainableScoreScript)((Object)leafScript)).explain(subQueryScore, ScriptScoreFunction.this.functionName);
                return exp;
            }
        };
    }

    @Override
    public boolean needsScores() {
        return this.script.needs_score();
    }

    public String toString() {
        return "script" + this.sScript.toString();
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        ScriptScoreFunction scriptScoreFunction = (ScriptScoreFunction)other;
        return Objects.equals(this.sScript, scriptScoreFunction.sScript);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.sScript);
    }

    static final class CannedScorer
    extends Scorable {
        protected int docid;
        protected float score;

        CannedScorer() {
        }

        @Override
        public int docID() {
            return this.docid;
        }

        @Override
        public float score() {
            return this.score;
        }
    }
}

